/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceFromRdsRequest extends MachineLearningRequest implements
        ToCopyableBuilder<CreateDataSourceFromRdsRequest.Builder, CreateDataSourceFromRdsRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDataSourceFromRdsRequest::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDataSourceFromRdsRequest::dataSourceName)).setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()).build();

    private static final SdkField<RDSDataSpec> RDS_DATA_FIELD = SdkField.<RDSDataSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDataSourceFromRdsRequest::rdsData)).setter(setter(Builder::rdsData))
            .constructor(RDSDataSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RDSData").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDataSourceFromRdsRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<Boolean> COMPUTE_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateDataSourceFromRdsRequest::computeStatistics)).setter(setter(Builder::computeStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            DATA_SOURCE_NAME_FIELD, RDS_DATA_FIELD, ROLE_ARN_FIELD, COMPUTE_STATISTICS_FIELD));

    private final String dataSourceId;

    private final String dataSourceName;

    private final RDSDataSpec rdsData;

    private final String roleARN;

    private final Boolean computeStatistics;

    private CreateDataSourceFromRdsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.rdsData = builder.rdsData;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number
     * (ARN) becomes the ID for a <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource
     *         Number (ARN) becomes the ID for a <code>DataSource</code>.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The data specification of an Amazon RDS <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DatabaseInformation -
     * <ul>
     * <li> <code>DatabaseName</code> - The name of the Amazon RDS database.</li>
     * <li> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</li>
     * </ul>
     * </p>
     * </li>
     * <li>
     * <p>
     * DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon
     * RDS database.
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task
     * from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
     * data pipelines.
     * </p>
     * </li>
     * <li>
     * <p>
     * ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress
     * of the copy task from Amazon RDS to Amazon S3. For more information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
     * data pipelines.
     * </p>
     * </li>
     * <li>
     * <p>
     * SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate
     * ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [
     * <code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using
     * <code>SelectSqlQuery</code> is stored in this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     * <code>Datasource</code>.
     * </p>
     * <br>
     * <p>
     * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The data specification of an Amazon RDS <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DatabaseInformation -
     *         <ul>
     *         <li> <code>DatabaseName</code> - The name of the Amazon RDS database.</li>
     *         <li> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</li>
     *         </ul>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to
     *         the Amazon RDS database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy
     *         task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a>
     *         for data pipelines.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the
     *         progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a>
     *         for data pipelines.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SecurityInfo - The security information to use to access an RDS DB instance. You need to set up
     *         appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS
     *         instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB
     *         instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon
     *         RDS using <code>SelectSqlQuery</code> is stored in this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     *         specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     *         <code>Datasource</code>.
     *         </p>
     *         <br>
     *         <p>
     *         Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     *         </p>
     *         </li>
     */
    public RDSDataSpec rdsData() {
        return rdsData;
    }

    /**
     * <p>
     * The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's
     * account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.
     * </p>
     * <p>
     * </p>
     * 
     * @return The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the
     *         user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon
     *         S3.</p>
     *         <p>
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
     * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
     * training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be
     * used for <code>MLModel</code> training.
     * </p>
     * 
     * @return The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation
     *         data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during
     *         <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>
     *         DataSource<code></code> needs to be used for <code>MLModel</code> training.
     */
    public Boolean computeStatistics() {
        return computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(rdsData());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(computeStatistics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRdsRequest)) {
            return false;
        }
        CreateDataSourceFromRdsRequest other = (CreateDataSourceFromRdsRequest) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(rdsData(), other.rdsData()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(computeStatistics(), other.computeStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDataSourceFromRdsRequest").add("DataSourceId", dataSourceId())
                .add("DataSourceName", dataSourceName()).add("RDSData", rdsData()).add("RoleARN", roleARN())
                .add("ComputeStatistics", computeStatistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "DataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "RDSData":
            return Optional.ofNullable(clazz.cast(rdsData()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "ComputeStatistics":
            return Optional.ofNullable(clazz.cast(computeStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromRdsRequest, T> g) {
        return obj -> g.apply((CreateDataSourceFromRdsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataSourceFromRdsRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number
         * (ARN) becomes the ID for a <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource
         *        Number (ARN) becomes the ID for a <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceName
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The data specification of an Amazon RDS <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DatabaseInformation -
         * <ul>
         * <li> <code>DatabaseName</code> - The name of the Amazon RDS database.</li>
         * <li> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</li>
         * </ul>
         * </p>
         * </li>
         * <li>
         * <p>
         * DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the
         * Amazon RDS database.
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task
         * from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * </li>
         * <li>
         * <p>
         * ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the
         * progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * </li>
         * <li>
         * <p>
         * SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate
         * ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [
         * <code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS
         * using <code>SelectSqlQuery</code> is stored in this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>Datasource</code>.
         * </p>
         * <br>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param rdsData
         *        The data specification of an Amazon RDS <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DatabaseInformation -
         *        <ul>
         *        <li> <code>DatabaseName</code> - The name of the Amazon RDS database.</li>
         *        <li> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</li>
         *        </ul>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to
         *        the Amazon RDS database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the
         *        copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role
         *        templates</a> for data pipelines.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the
         *        progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role
         *        templates</a> for data pipelines.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SecurityInfo - The security information to use to access an RDS DB instance. You need to set up
         *        appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS
         *        instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB
         *        instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon
         *        RDS using <code>SelectSqlQuery</code> is stored in this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code>
         *        is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         *        <code>Datasource</code>.
         *        </p>
         *        <br>
         *        <p>
         *        Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsData(RDSDataSpec rdsData);

        /**
         * <p>
         * The data specification of an Amazon RDS <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DatabaseInformation -
         * <ul>
         * <li> <code>DatabaseName</code> - The name of the Amazon RDS database.</li>
         * <li> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</li>
         * </ul>
         * </p>
         * </li>
         * <li>
         * <p>
         * DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the
         * Amazon RDS database.
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task
         * from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * </li>
         * <li>
         * <p>
         * ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the
         * progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * </li>
         * <li>
         * <p>
         * SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate
         * ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [
         * <code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS
         * using <code>SelectSqlQuery</code> is stored in this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>Datasource</code>.
         * </p>
         * <br>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link RDSDataSpec.Builder} avoiding the need to create
         * one manually via {@link RDSDataSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link RDSDataSpec.Builder#build()} is called immediately and its result
         * is passed to {@link #rdsData(RDSDataSpec)}.
         * 
         * @param rdsData
         *        a consumer that will call methods on {@link RDSDataSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsData(RDSDataSpec)
         */
        default Builder rdsData(Consumer<RDSDataSpec.Builder> rdsData) {
            return rdsData(RDSDataSpec.builder().applyMutation(rdsData).build());
        }

        /**
         * <p>
         * The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's
         * account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.
         * </p>
         * <p>
         * </p>
         * 
         * @param roleARN
         *        The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the
         *        user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon
         *        S3.</p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
         * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
         * training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs
         * to be used for <code>MLModel</code> training.
         * </p>
         * 
         * @param computeStatistics
         *        The compute statistics for a <code>DataSource</code>. The statistics are generated from the
         *        observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally
         *        during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
         *        <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceName;

        private RDSDataSpec rdsData;

        private String roleARN;

        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRdsRequest model) {
            super(model);
            dataSourceId(model.dataSourceId);
            dataSourceName(model.dataSourceName);
            rdsData(model.rdsData);
            roleARN(model.roleARN);
            computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RDSDataSpec.Builder getRdsData() {
            return rdsData != null ? rdsData.toBuilder() : null;
        }

        @Override
        public final Builder rdsData(RDSDataSpec rdsData) {
            this.rdsData = rdsData;
            return this;
        }

        public final void setRdsData(RDSDataSpec.BuilderImpl rdsData) {
            this.rdsData = rdsData != null ? rdsData.build() : null;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromRdsRequest build() {
            return new CreateDataSourceFromRdsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
