/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;

public class DescribeDataSourcesIterable
implements SdkIterable<DescribeDataSourcesResponse> {
    private final MachineLearningClient client;
    private final DescribeDataSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataSourcesIterable(MachineLearningClient client, DescribeDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataSourcesResponseFetcher();
    }

    public Iterator<DescribeDataSourcesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DataSource> results() {
        Function<DescribeDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDataSourcesIterable resume(DescribeDataSourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDataSourcesIterable(this.client, (DescribeDataSourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeDataSourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDataSourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDataSourcesResponseFetcher
    implements SyncPageFetcher<DescribeDataSourcesResponse> {
        private DescribeDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSourcesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeDataSourcesResponse nextPage(DescribeDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSourcesIterable.this.client.describeDataSources(DescribeDataSourcesIterable.this.firstRequest);
            }
            return DescribeDataSourcesIterable.this.client.describeDataSources((DescribeDataSourcesRequest)((Object)DescribeDataSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

