/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateBatchPredictionRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, UpdateBatchPredictionRequest> {
    private final String batchPredictionId;
    private final String batchPredictionName;

    private UpdateBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
        this.batchPredictionName = builder.batchPredictionName;
    }

    public String batchPredictionId() {
        return this.batchPredictionId;
    }

    public String batchPredictionName() {
        return this.batchPredictionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBatchPredictionRequest)) {
            return false;
        }
        UpdateBatchPredictionRequest other = (UpdateBatchPredictionRequest)((Object)obj);
        return Objects.equals(this.batchPredictionId(), other.batchPredictionId()) && Objects.equals(this.batchPredictionName(), other.batchPredictionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.batchPredictionId() != null) {
            sb.append("BatchPredictionId: ").append(this.batchPredictionId()).append(",");
        }
        if (this.batchPredictionName() != null) {
            sb.append("BatchPredictionName: ").append(this.batchPredictionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchPredictionId": {
                return Optional.of(clazz.cast(this.batchPredictionId()));
            }
            case "BatchPredictionName": {
                return Optional.of(clazz.cast(this.batchPredictionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String batchPredictionId;
        private String batchPredictionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBatchPredictionRequest model) {
            this.batchPredictionId(model.batchPredictionId);
            this.batchPredictionName(model.batchPredictionName);
        }

        public final String getBatchPredictionId() {
            return this.batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getBatchPredictionName() {
            return this.batchPredictionName;
        }

        @Override
        public final Builder batchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
            return this;
        }

        public final void setBatchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateBatchPredictionRequest build() {
            return new UpdateBatchPredictionRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, UpdateBatchPredictionRequest> {
        public Builder batchPredictionId(String var1);

        public Builder batchPredictionName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

