/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus;
import software.amazon.awssdk.services.machinelearning.transform.RealtimeEndpointInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RealtimeEndpointInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, RealtimeEndpointInfo> {
    private final Integer peakRequestsPerSecond;
    private final Instant createdAt;
    private final String endpointUrl;
    private final String endpointStatus;

    private RealtimeEndpointInfo(BuilderImpl builder) {
        this.peakRequestsPerSecond = builder.peakRequestsPerSecond;
        this.createdAt = builder.createdAt;
        this.endpointUrl = builder.endpointUrl;
        this.endpointStatus = builder.endpointStatus;
    }

    public Integer peakRequestsPerSecond() {
        return this.peakRequestsPerSecond;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public RealtimeEndpointStatus endpointStatus() {
        return RealtimeEndpointStatus.fromValue(this.endpointStatus);
    }

    public String endpointStatusString() {
        return this.endpointStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.peakRequestsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeEndpointInfo)) {
            return false;
        }
        RealtimeEndpointInfo other = (RealtimeEndpointInfo)obj;
        return Objects.equals(this.peakRequestsPerSecond(), other.peakRequestsPerSecond()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.endpointUrl(), other.endpointUrl()) && Objects.equals(this.endpointStatusString(), other.endpointStatusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.peakRequestsPerSecond() != null) {
            sb.append("PeakRequestsPerSecond: ").append(this.peakRequestsPerSecond()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.endpointUrl() != null) {
            sb.append("EndpointUrl: ").append(this.endpointUrl()).append(",");
        }
        if (this.endpointStatusString() != null) {
            sb.append("EndpointStatus: ").append(this.endpointStatusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeakRequestsPerSecond": {
                return Optional.of(clazz.cast(this.peakRequestsPerSecond()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "EndpointUrl": {
                return Optional.of(clazz.cast(this.endpointUrl()));
            }
            case "EndpointStatus": {
                return Optional.of(clazz.cast(this.endpointStatusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RealtimeEndpointInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer peakRequestsPerSecond;
        private Instant createdAt;
        private String endpointUrl;
        private String endpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeEndpointInfo model) {
            this.peakRequestsPerSecond(model.peakRequestsPerSecond);
            this.createdAt(model.createdAt);
            this.endpointUrl(model.endpointUrl);
            this.endpointStatus(model.endpointStatus);
        }

        public final Integer getPeakRequestsPerSecond() {
            return this.peakRequestsPerSecond;
        }

        @Override
        public final Builder peakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
            return this;
        }

        public final void setPeakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(RealtimeEndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus.toString());
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public RealtimeEndpointInfo build() {
            return new RealtimeEndpointInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RealtimeEndpointInfo> {
        public Builder peakRequestsPerSecond(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder endpointUrl(String var1);

        public Builder endpointStatus(String var1);

        public Builder endpointStatus(RealtimeEndpointStatus var1);
    }
}

