/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDataSourceFromRedshiftRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromRedshiftRequest> {
    private final String dataSourceId;
    private final String dataSourceName;
    private final RedshiftDataSpec dataSpec;
    private final String roleARN;
    private final Boolean computeStatistics;

    private CreateDataSourceFromRedshiftRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public RedshiftDataSpec dataSpec() {
        return this.dataSpec;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRedshiftRequest)) {
            return false;
        }
        CreateDataSourceFromRedshiftRequest other = (CreateDataSourceFromRedshiftRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.dataSpec(), other.dataSpec()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.computeStatistics(), other.computeStatistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (this.dataSourceName() != null) {
            sb.append("DataSourceName: ").append(this.dataSourceName()).append(",");
        }
        if (this.dataSpec() != null) {
            sb.append("DataSpec: ").append(this.dataSpec()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(this.computeStatistics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.of(clazz.cast(this.dataSourceName()));
            }
            case "DataSpec": {
                return Optional.of(clazz.cast(this.dataSpec()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "ComputeStatistics": {
                return Optional.of(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private RedshiftDataSpec dataSpec;
        private String roleARN;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRedshiftRequest model) {
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.dataSpec(model.dataSpec);
            this.roleARN(model.roleARN);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RedshiftDataSpec.Builder getDataSpec() {
            return this.dataSpec != null ? this.dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(RedshiftDataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(RedshiftDataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromRedshiftRequest build() {
            return new CreateDataSourceFromRedshiftRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, CreateDataSourceFromRedshiftRequest> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder dataSpec(RedshiftDataSpec var1);

        default public Builder dataSpec(Consumer<RedshiftDataSpec.Builder> dataSpec) {
            return this.dataSpec((RedshiftDataSpec)((RedshiftDataSpec.Builder)RedshiftDataSpec.builder().apply(dataSpec)).build());
        }

        public Builder roleARN(String var1);

        public Builder computeStatistics(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

