/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.Evaluation;

public final class DescribeEvaluationsPaginator
implements SdkIterable<DescribeEvaluationsResponse> {
    private final MachineLearningClient client;
    private final DescribeEvaluationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEvaluationsPaginator(MachineLearningClient client, DescribeEvaluationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEvaluationsResponseFetcher();
    }

    public Iterator<DescribeEvaluationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Evaluation> results() {
        Function<DescribeEvaluationsResponse, Iterator> getIterator = response -> response != null ? response.results().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeEvaluationsResponseFetcher
    implements NextPageFetcher<DescribeEvaluationsResponse> {
        private DescribeEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEvaluationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeEvaluationsResponse nextPage(DescribeEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEvaluationsPaginator.this.client.describeEvaluations(DescribeEvaluationsPaginator.this.firstRequest);
            }
            return DescribeEvaluationsPaginator.this.client.describeEvaluations((DescribeEvaluationsRequest)((Object)DescribeEvaluationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

