/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMLModelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetMLModelRequest> {
    private final String mlModelId;
    private final Boolean verbose;

    private GetMLModelRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.verbose = builder.verbose;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public Boolean verbose() {
        return this.verbose;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.verbose() == null ? 0 : this.verbose().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMLModelRequest)) {
            return false;
        }
        GetMLModelRequest other = (GetMLModelRequest)((Object)obj);
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.verbose() == null ^ this.verbose() == null) {
            return false;
        }
        return other.verbose() == null || other.verbose().equals(this.verbose());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.verbose() != null) {
            sb.append("Verbose: ").append(this.verbose()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "Verbose": {
                return Optional.of(clazz.cast(this.verbose()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String mlModelId;
        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMLModelRequest model) {
            this.mlModelId(model.mlModelId);
            this.verbose(model.verbose);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        public GetMLModelRequest build() {
            return new GetMLModelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMLModelRequest> {
        public Builder mlModelId(String var1);

        public Builder verbose(Boolean var1);
    }
}

