/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.machinelearning.model.RDSDataSpec;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDataSourceFromRDSRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromRDSRequest> {
    private final String dataSourceId;
    private final String dataSourceName;
    private final RDSDataSpec rdsData;
    private final String roleARN;
    private final Boolean computeStatistics;

    private CreateDataSourceFromRDSRequest(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.rdsData = builder.rdsData;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public RDSDataSpec rdsData() {
        return this.rdsData;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataSourceId() == null ? 0 : this.dataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.dataSourceName() == null ? 0 : this.dataSourceName().hashCode());
        hashCode = 31 * hashCode + (this.rdsData() == null ? 0 : this.rdsData().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.computeStatistics() == null ? 0 : this.computeStatistics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRDSRequest)) {
            return false;
        }
        CreateDataSourceFromRDSRequest other = (CreateDataSourceFromRDSRequest)((Object)obj);
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataSourceName() == null ^ this.dataSourceName() == null) {
            return false;
        }
        if (other.dataSourceName() != null && !other.dataSourceName().equals(this.dataSourceName())) {
            return false;
        }
        if (other.rdsData() == null ^ this.rdsData() == null) {
            return false;
        }
        if (other.rdsData() != null && !other.rdsData().equals(this.rdsData())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.computeStatistics() == null ^ this.computeStatistics() == null) {
            return false;
        }
        return other.computeStatistics() == null || other.computeStatistics().equals(this.computeStatistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (this.dataSourceName() != null) {
            sb.append("DataSourceName: ").append(this.dataSourceName()).append(",");
        }
        if (this.rdsData() != null) {
            sb.append("RDSData: ").append(this.rdsData()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(this.computeStatistics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.of(clazz.cast(this.dataSourceName()));
            }
            case "RDSData": {
                return Optional.of(clazz.cast(this.rdsData()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "ComputeStatistics": {
                return Optional.of(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private RDSDataSpec rdsData;
        private String roleARN;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRDSRequest model) {
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.rdsData(model.rdsData);
            this.roleARN(model.roleARN);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RDSDataSpec.Builder getRDSData() {
            return this.rdsData != null ? this.rdsData.toBuilder() : null;
        }

        @Override
        public final Builder rdsData(RDSDataSpec rdsData) {
            this.rdsData = rdsData;
            return this;
        }

        public final void setRDSData(RDSDataSpec.BuilderImpl rdsData) {
            this.rdsData = rdsData != null ? rdsData.build() : null;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        public CreateDataSourceFromRDSRequest build() {
            return new CreateDataSourceFromRDSRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDataSourceFromRDSRequest> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder rdsData(RDSDataSpec var1);

        public Builder roleARN(String var1);

        public Builder computeStatistics(Boolean var1);
    }
}

