/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.internal;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.core.AmazonClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class PredictEndpointInterceptor
implements ExecutionInterceptor {
    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof PredictRequest) {
            PredictRequest pr = (PredictRequest)originalRequest;
            if (pr.predictEndpoint() == null) {
                throw new AmazonClientException("PredictRequest.PredictEndpoint is required!");
            }
            try {
                URI endpoint = new URI(pr.predictEndpoint());
                return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).protocol(endpoint.getScheme()).host(endpoint.getHost()).port(Integer.valueOf(endpoint.getPort())).encodedPath(SdkHttpUtils.appendUri((String)endpoint.getPath(), (String)request.encodedPath())).build();
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse PredictRequest.PredictEndpoint", (Throwable)e);
            }
        }
        return request;
    }
}

