/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RDSDatabase
implements StructuredPojo,
ToCopyableBuilder<Builder, RDSDatabase> {
    private final String instanceIdentifier;
    private final String databaseName;

    private RDSDatabase(BuilderImpl builder) {
        this.instanceIdentifier = builder.instanceIdentifier;
        this.databaseName = builder.databaseName;
    }

    public String instanceIdentifier() {
        return this.instanceIdentifier;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceIdentifier() == null ? 0 : this.instanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.databaseName() == null ? 0 : this.databaseName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabase)) {
            return false;
        }
        RDSDatabase other = (RDSDatabase)obj;
        if (other.instanceIdentifier() == null ^ this.instanceIdentifier() == null) {
            return false;
        }
        if (other.instanceIdentifier() != null && !other.instanceIdentifier().equals(this.instanceIdentifier())) {
            return false;
        }
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        return other.databaseName() == null || other.databaseName().equals(this.databaseName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceIdentifier() != null) {
            sb.append("InstanceIdentifier: ").append(this.instanceIdentifier()).append(",");
        }
        if (this.databaseName() != null) {
            sb.append("DatabaseName: ").append(this.databaseName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceIdentifier;
        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabase model) {
            this.setInstanceIdentifier(model.instanceIdentifier);
            this.setDatabaseName(model.databaseName);
        }

        public final String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public final void setInstanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public RDSDatabase build() {
            return new RDSDatabase(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RDSDatabase> {
        public Builder instanceIdentifier(String var1);

        public Builder databaseName(String var1);
    }
}

