/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RDSMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RDSMetadataMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASEUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseUserName").isBinary(false).build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceRole").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();
    private static final MarshallingInfo<String> DATAPIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataPipelineId").isBinary(false).build();
    private static final RDSMetadataMarshaller INSTANCE = new RDSMetadataMarshaller();

    private RDSMetadataMarshaller() {
    }

    public static RDSMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSMetadata rdsMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rdsMetadata, (String)"rdsMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rdsMetadata.database(), DATABASE_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.databaseUserName(), DATABASEUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.selectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.resourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.dataPipelineId(), DATAPIPELINEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

