/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.TaggableResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddTagsResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, AddTagsResponse> {
    private final String resourceId;
    private final String resourceType;

    private AddTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsResponse)) {
            return false;
        }
        AddTagsResponse other = (AddTagsResponse)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AddTagsResponse").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsResponse model) {
            super(model);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public AddTagsResponse build() {
            return new AddTagsResponse(this);
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    CopyableBuilder<Builder, AddTagsResponse> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TaggableResourceType var1);
    }
}

