/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEvaluationRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, UpdateEvaluationRequest> {
    private final String evaluationId;
    private final String evaluationName;

    private UpdateEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.evaluationName = builder.evaluationName;
    }

    public String evaluationId() {
        return this.evaluationId;
    }

    public String evaluationName() {
        return this.evaluationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEvaluationRequest)) {
            return false;
        }
        UpdateEvaluationRequest other = (UpdateEvaluationRequest)((Object)obj);
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationName(), other.evaluationName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEvaluationRequest").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationName", (Object)this.evaluationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "EvaluationName": {
                return Optional.ofNullable(clazz.cast(this.evaluationName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEvaluationRequest model) {
            super(model);
            this.evaluationId(model.evaluationId);
            this.evaluationName(model.evaluationName);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getEvaluationName() {
            return this.evaluationName;
        }

        @Override
        public final Builder evaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
            return this;
        }

        public final void setEvaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEvaluationRequest build() {
            return new UpdateEvaluationRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, UpdateEvaluationRequest> {
        public Builder evaluationId(String var1);

        public Builder evaluationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

