/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateMLModelRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, UpdateMLModelRequest> {
    private final String mlModelId;
    private final String mlModelName;
    private final Float scoreThreshold;

    private UpdateMLModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.scoreThreshold = builder.scoreThreshold;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String mlModelName() {
        return this.mlModelName;
    }

    public Float scoreThreshold() {
        return this.scoreThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMLModelRequest)) {
            return false;
        }
        UpdateMLModelRequest other = (UpdateMLModelRequest)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.mlModelName(), other.mlModelName()) && Objects.equals(this.scoreThreshold(), other.scoreThreshold());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMLModelRequest").add("MLModelId", (Object)this.mlModelId()).add("MLModelName", (Object)this.mlModelName()).add("ScoreThreshold", (Object)this.scoreThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "MLModelName": {
                return Optional.of(clazz.cast(this.mlModelName()));
            }
            case "ScoreThreshold": {
                return Optional.of(clazz.cast(this.scoreThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String mlModelId;
        private String mlModelName;
        private Float scoreThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMLModelRequest model) {
            super(model);
            this.mlModelId(model.mlModelId);
            this.mlModelName(model.mlModelName);
            this.scoreThreshold(model.scoreThreshold);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return this.mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final Float getScoreThreshold() {
            return this.scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateMLModelRequest build() {
            return new UpdateMLModelRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, UpdateMLModelRequest> {
        public Builder mlModelId(String var1);

        public Builder mlModelName(String var1);

        public Builder scoreThreshold(Float var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

