/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBatchPredictionRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateBatchPredictionRequest> {
    private final String batchPredictionId;
    private final String batchPredictionName;
    private final String mlModelId;
    private final String batchPredictionDataSourceId;
    private final String outputUri;

    private CreateBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
        this.batchPredictionName = builder.batchPredictionName;
        this.mlModelId = builder.mlModelId;
        this.batchPredictionDataSourceId = builder.batchPredictionDataSourceId;
        this.outputUri = builder.outputUri;
    }

    public String batchPredictionId() {
        return this.batchPredictionId;
    }

    public String batchPredictionName() {
        return this.batchPredictionName;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String batchPredictionDataSourceId() {
        return this.batchPredictionDataSourceId;
    }

    public String outputUri() {
        return this.outputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchPredictionRequest)) {
            return false;
        }
        CreateBatchPredictionRequest other = (CreateBatchPredictionRequest)((Object)obj);
        return Objects.equals(this.batchPredictionId(), other.batchPredictionId()) && Objects.equals(this.batchPredictionName(), other.batchPredictionName()) && Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.batchPredictionDataSourceId(), other.batchPredictionDataSourceId()) && Objects.equals(this.outputUri(), other.outputUri());
    }

    public String toString() {
        return ToString.builder((String)"CreateBatchPredictionRequest").add("BatchPredictionId", (Object)this.batchPredictionId()).add("BatchPredictionName", (Object)this.batchPredictionName()).add("MLModelId", (Object)this.mlModelId()).add("BatchPredictionDataSourceId", (Object)this.batchPredictionDataSourceId()).add("OutputUri", (Object)this.outputUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchPredictionId": {
                return Optional.of(clazz.cast(this.batchPredictionId()));
            }
            case "BatchPredictionName": {
                return Optional.of(clazz.cast(this.batchPredictionName()));
            }
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "BatchPredictionDataSourceId": {
                return Optional.of(clazz.cast(this.batchPredictionDataSourceId()));
            }
            case "OutputUri": {
                return Optional.of(clazz.cast(this.outputUri()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String batchPredictionId;
        private String batchPredictionName;
        private String mlModelId;
        private String batchPredictionDataSourceId;
        private String outputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchPredictionRequest model) {
            super(model);
            this.batchPredictionId(model.batchPredictionId);
            this.batchPredictionName(model.batchPredictionName);
            this.mlModelId(model.mlModelId);
            this.batchPredictionDataSourceId(model.batchPredictionDataSourceId);
            this.outputUri(model.outputUri);
        }

        public final String getBatchPredictionId() {
            return this.batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getBatchPredictionName() {
            return this.batchPredictionName;
        }

        @Override
        public final Builder batchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
            return this;
        }

        public final void setBatchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getBatchPredictionDataSourceId() {
            return this.batchPredictionDataSourceId;
        }

        @Override
        public final Builder batchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
            return this;
        }

        public final void setBatchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchPredictionRequest build() {
            return new CreateBatchPredictionRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, CreateBatchPredictionRequest> {
        public Builder batchPredictionId(String var1);

        public Builder batchPredictionName(String var1);

        public Builder mlModelId(String var1);

        public Builder batchPredictionDataSourceId(String var1);

        public Builder outputUri(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

