/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;

@SdkInternalApi
public class S3DataSpecMarshaller {
    private static final MarshallingInfo<String> DATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocationS3").build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").build();
    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").build();
    private static final MarshallingInfo<String> DATASCHEMALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaLocationS3").build();
    private static final S3DataSpecMarshaller instance = new S3DataSpecMarshaller();

    public static S3DataSpecMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DataSpec s3DataSpec, ProtocolMarshaller protocolMarshaller) {
        if (s3DataSpec == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3DataSpec.dataLocationS3(), DATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)s3DataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall((Object)s3DataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall((Object)s3DataSpec.dataSchemaLocationS3(), DATASCHEMALOCATIONS3_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

