/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.machinelearning.model.EDPSecurityGroupIdsCopier;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials;
import software.amazon.awssdk.services.machinelearning.transform.RDSDataSpecMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RDSDataSpec
implements StructuredPojo,
ToCopyableBuilder<Builder, RDSDataSpec> {
    private final RDSDatabase databaseInformation;
    private final String selectSqlQuery;
    private final RDSDatabaseCredentials databaseCredentials;
    private final String s3StagingLocation;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaUri;
    private final String resourceRole;
    private final String serviceRole;
    private final String subnetId;
    private final List<String> securityGroupIds;

    private RDSDataSpec(BuilderImpl builder) {
        this.databaseInformation = builder.databaseInformation;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.databaseCredentials = builder.databaseCredentials;
        this.s3StagingLocation = builder.s3StagingLocation;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaUri = builder.dataSchemaUri;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public RDSDatabase databaseInformation() {
        return this.databaseInformation;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public RDSDatabaseCredentials databaseCredentials() {
        return this.databaseCredentials;
    }

    public String s3StagingLocation() {
        return this.s3StagingLocation;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String dataSchema() {
        return this.dataSchema;
    }

    public String dataSchemaUri() {
        return this.dataSchemaUri;
    }

    public String resourceRole() {
        return this.resourceRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.databaseInformation() == null ? 0 : this.databaseInformation().hashCode());
        hashCode = 31 * hashCode + (this.selectSqlQuery() == null ? 0 : this.selectSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.databaseCredentials() == null ? 0 : this.databaseCredentials().hashCode());
        hashCode = 31 * hashCode + (this.s3StagingLocation() == null ? 0 : this.s3StagingLocation().hashCode());
        hashCode = 31 * hashCode + (this.dataRearrangement() == null ? 0 : this.dataRearrangement().hashCode());
        hashCode = 31 * hashCode + (this.dataSchema() == null ? 0 : this.dataSchema().hashCode());
        hashCode = 31 * hashCode + (this.dataSchemaUri() == null ? 0 : this.dataSchemaUri().hashCode());
        hashCode = 31 * hashCode + (this.resourceRole() == null ? 0 : this.resourceRole().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDataSpec)) {
            return false;
        }
        RDSDataSpec other = (RDSDataSpec)obj;
        if (other.databaseInformation() == null ^ this.databaseInformation() == null) {
            return false;
        }
        if (other.databaseInformation() != null && !other.databaseInformation().equals(this.databaseInformation())) {
            return false;
        }
        if (other.selectSqlQuery() == null ^ this.selectSqlQuery() == null) {
            return false;
        }
        if (other.selectSqlQuery() != null && !other.selectSqlQuery().equals(this.selectSqlQuery())) {
            return false;
        }
        if (other.databaseCredentials() == null ^ this.databaseCredentials() == null) {
            return false;
        }
        if (other.databaseCredentials() != null && !other.databaseCredentials().equals(this.databaseCredentials())) {
            return false;
        }
        if (other.s3StagingLocation() == null ^ this.s3StagingLocation() == null) {
            return false;
        }
        if (other.s3StagingLocation() != null && !other.s3StagingLocation().equals(this.s3StagingLocation())) {
            return false;
        }
        if (other.dataRearrangement() == null ^ this.dataRearrangement() == null) {
            return false;
        }
        if (other.dataRearrangement() != null && !other.dataRearrangement().equals(this.dataRearrangement())) {
            return false;
        }
        if (other.dataSchema() == null ^ this.dataSchema() == null) {
            return false;
        }
        if (other.dataSchema() != null && !other.dataSchema().equals(this.dataSchema())) {
            return false;
        }
        if (other.dataSchemaUri() == null ^ this.dataSchemaUri() == null) {
            return false;
        }
        if (other.dataSchemaUri() != null && !other.dataSchemaUri().equals(this.dataSchemaUri())) {
            return false;
        }
        if (other.resourceRole() == null ^ this.resourceRole() == null) {
            return false;
        }
        if (other.resourceRole() != null && !other.resourceRole().equals(this.resourceRole())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        return other.securityGroupIds() == null || other.securityGroupIds().equals(this.securityGroupIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.databaseInformation() != null) {
            sb.append("DatabaseInformation: ").append(this.databaseInformation()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (this.databaseCredentials() != null) {
            sb.append("DatabaseCredentials: ").append(this.databaseCredentials()).append(",");
        }
        if (this.s3StagingLocation() != null) {
            sb.append("S3StagingLocation: ").append(this.s3StagingLocation()).append(",");
        }
        if (this.dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.dataRearrangement()).append(",");
        }
        if (this.dataSchema() != null) {
            sb.append("DataSchema: ").append(this.dataSchema()).append(",");
        }
        if (this.dataSchemaUri() != null) {
            sb.append("DataSchemaUri: ").append(this.dataSchemaUri()).append(",");
        }
        if (this.resourceRole() != null) {
            sb.append("ResourceRole: ").append(this.resourceRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private RDSDatabase databaseInformation;
        private String selectSqlQuery;
        private RDSDatabaseCredentials databaseCredentials;
        private String s3StagingLocation;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaUri;
        private String resourceRole;
        private String serviceRole;
        private String subnetId;
        private List<String> securityGroupIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDataSpec model) {
            this.setDatabaseInformation(model.databaseInformation);
            this.setSelectSqlQuery(model.selectSqlQuery);
            this.setDatabaseCredentials(model.databaseCredentials);
            this.setS3StagingLocation(model.s3StagingLocation);
            this.setDataRearrangement(model.dataRearrangement);
            this.setDataSchema(model.dataSchema);
            this.setDataSchemaUri(model.dataSchemaUri);
            this.setResourceRole(model.resourceRole);
            this.setServiceRole(model.serviceRole);
            this.setSubnetId(model.subnetId);
            this.setSecurityGroupIds(model.securityGroupIds);
        }

        public final RDSDatabase getDatabaseInformation() {
            return this.databaseInformation;
        }

        @Override
        public final Builder databaseInformation(RDSDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
            return this;
        }

        public final void setDatabaseInformation(RDSDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final RDSDatabaseCredentials getDatabaseCredentials() {
            return this.databaseCredentials;
        }

        @Override
        public final Builder databaseCredentials(RDSDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public final void setDatabaseCredentials(RDSDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
        }

        public final String getS3StagingLocation() {
            return this.s3StagingLocation;
        }

        @Override
        public final Builder s3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
            return this;
        }

        public final void setS3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        public final String getDataSchemaUri() {
            return this.dataSchemaUri;
        }

        @Override
        public final Builder dataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
            return this;
        }

        public final void setDataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = EDPSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new SdkInternalList(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = EDPSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new SdkInternalList(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
        }

        public RDSDataSpec build() {
            return new RDSDataSpec(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RDSDataSpec> {
        public Builder databaseInformation(RDSDatabase var1);

        public Builder selectSqlQuery(String var1);

        public Builder databaseCredentials(RDSDatabaseCredentials var1);

        public Builder s3StagingLocation(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaUri(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceRole(String var1);

        public Builder subnetId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

