/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEvaluationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateEvaluationRequest> {
    private final String evaluationId;
    private final String evaluationName;
    private final String mlModelId;
    private final String evaluationDataSourceId;

    private CreateEvaluationRequest(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationName = builder.evaluationName;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
    }

    public String evaluationId() {
        return this.evaluationId;
    }

    public String evaluationName() {
        return this.evaluationName;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String evaluationDataSourceId() {
        return this.evaluationDataSourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.evaluationId() == null ? 0 : this.evaluationId().hashCode());
        hashCode = 31 * hashCode + (this.evaluationName() == null ? 0 : this.evaluationName().hashCode());
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.evaluationDataSourceId() == null ? 0 : this.evaluationDataSourceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationRequest)) {
            return false;
        }
        CreateEvaluationRequest other = (CreateEvaluationRequest)((Object)obj);
        if (other.evaluationId() == null ^ this.evaluationId() == null) {
            return false;
        }
        if (other.evaluationId() != null && !other.evaluationId().equals(this.evaluationId())) {
            return false;
        }
        if (other.evaluationName() == null ^ this.evaluationName() == null) {
            return false;
        }
        if (other.evaluationName() != null && !other.evaluationName().equals(this.evaluationName())) {
            return false;
        }
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.evaluationDataSourceId() == null ^ this.evaluationDataSourceId() == null) {
            return false;
        }
        return other.evaluationDataSourceId() == null || other.evaluationDataSourceId().equals(this.evaluationDataSourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evaluationId() != null) {
            sb.append("EvaluationId: ").append(this.evaluationId()).append(",");
        }
        if (this.evaluationName() != null) {
            sb.append("EvaluationName: ").append(this.evaluationName()).append(",");
        }
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.evaluationDataSourceId() != null) {
            sb.append("EvaluationDataSourceId: ").append(this.evaluationDataSourceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationName;
        private String mlModelId;
        private String evaluationDataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationRequest model) {
            this.setEvaluationId(model.evaluationId);
            this.setEvaluationName(model.evaluationName);
            this.setMLModelId(model.mlModelId);
            this.setEvaluationDataSourceId(model.evaluationDataSourceId);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getEvaluationName() {
            return this.evaluationName;
        }

        @Override
        public final Builder evaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
            return this;
        }

        public final void setEvaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getEvaluationDataSourceId() {
            return this.evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        public CreateEvaluationRequest build() {
            return new CreateEvaluationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateEvaluationRequest> {
        public Builder evaluationId(String var1);

        public Builder evaluationName(String var1);

        public Builder mlModelId(String var1);

        public Builder evaluationDataSourceId(String var1);
    }
}

