/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopApplicationRequest extends M2Request implements
        ToCopyableBuilder<StopApplicationRequest.Builder, StopApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(StopApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<Boolean> FORCE_STOP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceStop").getter(getter(StopApplicationRequest::forceStop)).setter(setter(Builder::forceStop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceStop").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            FORCE_STOP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final Boolean forceStop;

    private StopApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.forceStop = builder.forceStop;
    }

    /**
     * <p>
     * The unique identifier of the application you want to stop.
     * </p>
     * 
     * @return The unique identifier of the application you want to stop.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * Stopping an application process can take a long time. Setting this parameter to true lets you force stop the
     * application so you don't need to wait until the process finishes to apply another action on the application. The
     * default value is false.
     * </p>
     * 
     * @return Stopping an application process can take a long time. Setting this parameter to true lets you force stop
     *         the application so you don't need to wait until the process finishes to apply another action on the
     *         application. The default value is false.
     */
    public final Boolean forceStop() {
        return forceStop;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(forceStop());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopApplicationRequest)) {
            return false;
        }
        StopApplicationRequest other = (StopApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(forceStop(), other.forceStop());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopApplicationRequest").add("ApplicationId", applicationId()).add("ForceStop", forceStop())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "forceStop":
            return Optional.ofNullable(clazz.cast(forceStop()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("forceStop", FORCE_STOP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopApplicationRequest, T> g) {
        return obj -> g.apply((StopApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, StopApplicationRequest> {
        /**
         * <p>
         * The unique identifier of the application you want to stop.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * Stopping an application process can take a long time. Setting this parameter to true lets you force stop the
         * application so you don't need to wait until the process finishes to apply another action on the application.
         * The default value is false.
         * </p>
         * 
         * @param forceStop
         *        Stopping an application process can take a long time. Setting this parameter to true lets you force
         *        stop the application so you don't need to wait until the process finishes to apply another action on
         *        the application. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceStop(Boolean forceStop);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private Boolean forceStop;

        private BuilderImpl() {
        }

        private BuilderImpl(StopApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            forceStop(model.forceStop);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Boolean getForceStop() {
            return forceStop;
        }

        public final void setForceStop(Boolean forceStop) {
            this.forceStop = forceStop;
        }

        @Override
        public final Builder forceStop(Boolean forceStop) {
            this.forceStop = forceStop;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopApplicationRequest build() {
            return new StopApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
