/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSetExportHistoryResponse extends M2Response implements
        ToCopyableBuilder<ListDataSetExportHistoryResponse.Builder, ListDataSetExportHistoryResponse> {
    private static final SdkField<List<DataSetExportTask>> DATA_SET_EXPORT_TASKS_FIELD = SdkField
            .<List<DataSetExportTask>> builder(MarshallingType.LIST)
            .memberName("dataSetExportTasks")
            .getter(getter(ListDataSetExportHistoryResponse::dataSetExportTasks))
            .setter(setter(Builder::dataSetExportTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetExportTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetExportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetExportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataSetExportHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_EXPORT_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataSetExportTask> dataSetExportTasks;

    private final String nextToken;

    private ListDataSetExportHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetExportTasks = builder.dataSetExportTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSetExportTasks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSetExportTasks() {
        return dataSetExportTasks != null && !(dataSetExportTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data set export tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSetExportTasks} method.
     * </p>
     * 
     * @return The data set export tasks.
     */
    public final List<DataSetExportTask> dataSetExportTasks() {
        return dataSetExportTasks;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to this operation to
     * retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to this
     *         operation to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetExportTasks() ? dataSetExportTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetExportHistoryResponse)) {
            return false;
        }
        ListDataSetExportHistoryResponse other = (ListDataSetExportHistoryResponse) obj;
        return hasDataSetExportTasks() == other.hasDataSetExportTasks()
                && Objects.equals(dataSetExportTasks(), other.dataSetExportTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSetExportHistoryResponse")
                .add("DataSetExportTasks", hasDataSetExportTasks() ? dataSetExportTasks() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetExportTasks":
            return Optional.ofNullable(clazz.cast(dataSetExportTasks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSetExportTasks", DATA_SET_EXPORT_TASKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetExportHistoryResponse, T> g) {
        return obj -> g.apply((ListDataSetExportHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSetExportHistoryResponse> {
        /**
         * <p>
         * The data set export tasks.
         * </p>
         * 
         * @param dataSetExportTasks
         *        The data set export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetExportTasks(Collection<DataSetExportTask> dataSetExportTasks);

        /**
         * <p>
         * The data set export tasks.
         * </p>
         * 
         * @param dataSetExportTasks
         *        The data set export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetExportTasks(DataSetExportTask... dataSetExportTasks);

        /**
         * <p>
         * The data set export tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.DataSetExportTask.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.DataSetExportTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.DataSetExportTask.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSetExportTasks(List<DataSetExportTask>)}.
         * 
         * @param dataSetExportTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.DataSetExportTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetExportTasks(java.util.Collection<DataSetExportTask>)
         */
        Builder dataSetExportTasks(Consumer<DataSetExportTask.Builder>... dataSetExportTasks);

        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to this
         * operation to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to this
         *        operation to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<DataSetExportTask> dataSetExportTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetExportHistoryResponse model) {
            super(model);
            dataSetExportTasks(model.dataSetExportTasks);
            nextToken(model.nextToken);
        }

        public final List<DataSetExportTask.Builder> getDataSetExportTasks() {
            List<DataSetExportTask.Builder> result = DataSetExportTaskListCopier.copyToBuilder(this.dataSetExportTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetExportTasks(Collection<DataSetExportTask.BuilderImpl> dataSetExportTasks) {
            this.dataSetExportTasks = DataSetExportTaskListCopier.copyFromBuilder(dataSetExportTasks);
        }

        @Override
        public final Builder dataSetExportTasks(Collection<DataSetExportTask> dataSetExportTasks) {
            this.dataSetExportTasks = DataSetExportTaskListCopier.copy(dataSetExportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetExportTasks(DataSetExportTask... dataSetExportTasks) {
            dataSetExportTasks(Arrays.asList(dataSetExportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetExportTasks(Consumer<DataSetExportTask.Builder>... dataSetExportTasks) {
            dataSetExportTasks(Stream.of(dataSetExportTasks).map(c -> DataSetExportTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSetExportHistoryResponse build() {
            return new ListDataSetExportHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
