/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A file containing a batch job definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileBatchJobDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<FileBatchJobDefinition.Builder, FileBatchJobDefinition> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(FileBatchJobDefinition::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("folderPath").getter(getter(FileBatchJobDefinition::folderPath)).setter(setter(Builder::folderPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD,
            FOLDER_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileName;

    private final String folderPath;

    private FileBatchJobDefinition(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.folderPath = builder.folderPath;
    }

    /**
     * <p>
     * The name of the file containing the batch job definition.
     * </p>
     * 
     * @return The name of the file containing the batch job definition.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The path to the file containing the batch job definition.
     * </p>
     * 
     * @return The path to the file containing the batch job definition.
     */
    public final String folderPath() {
        return folderPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(folderPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileBatchJobDefinition)) {
            return false;
        }
        FileBatchJobDefinition other = (FileBatchJobDefinition) obj;
        return Objects.equals(fileName(), other.fileName()) && Objects.equals(folderPath(), other.folderPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileBatchJobDefinition").add("FileName", fileName()).add("FolderPath", folderPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "folderPath":
            return Optional.ofNullable(clazz.cast(folderPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileName", FILE_NAME_FIELD);
        map.put("folderPath", FOLDER_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileBatchJobDefinition, T> g) {
        return obj -> g.apply((FileBatchJobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileBatchJobDefinition> {
        /**
         * <p>
         * The name of the file containing the batch job definition.
         * </p>
         * 
         * @param fileName
         *        The name of the file containing the batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The path to the file containing the batch job definition.
         * </p>
         * 
         * @param folderPath
         *        The path to the file containing the batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderPath(String folderPath);
    }

    static final class BuilderImpl implements Builder {
        private String fileName;

        private String folderPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FileBatchJobDefinition model) {
            fileName(model.fileName);
            folderPath(model.folderPath);
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getFolderPath() {
            return folderPath;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        @Override
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        @Override
        public FileBatchJobDefinition build() {
            return new FileBatchJobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
