/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a specific data set to export from an external location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetExportItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetExportItem.Builder, DataSetExportItem> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(DataSetExportItem::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final SdkField<ExternalLocation> EXTERNAL_LOCATION_FIELD = SdkField
            .<ExternalLocation> builder(MarshallingType.SDK_POJO).memberName("externalLocation")
            .getter(getter(DataSetExportItem::externalLocation)).setter(setter(Builder::externalLocation))
            .constructor(ExternalLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            EXTERNAL_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetName;

    private final ExternalLocation externalLocation;

    private DataSetExportItem(BuilderImpl builder) {
        this.datasetName = builder.datasetName;
        this.externalLocation = builder.externalLocation;
    }

    /**
     * <p>
     * The data set.
     * </p>
     * 
     * @return The data set.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The location of the data set.
     * </p>
     * 
     * @return The location of the data set.
     */
    public final ExternalLocation externalLocation() {
        return externalLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(externalLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetExportItem)) {
            return false;
        }
        DataSetExportItem other = (DataSetExportItem) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(externalLocation(), other.externalLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetExportItem").add("DatasetName", datasetName())
                .add("ExternalLocation", externalLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "externalLocation":
            return Optional.ofNullable(clazz.cast(externalLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetName", DATASET_NAME_FIELD);
        map.put("externalLocation", EXTERNAL_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetExportItem, T> g) {
        return obj -> g.apply((DataSetExportItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetExportItem> {
        /**
         * <p>
         * The data set.
         * </p>
         * 
         * @param datasetName
         *        The data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The location of the data set.
         * </p>
         * 
         * @param externalLocation
         *        The location of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLocation(ExternalLocation externalLocation);

        /**
         * <p>
         * The location of the data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalLocation.Builder} avoiding the
         * need to create one manually via {@link ExternalLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #externalLocation(ExternalLocation)}.
         * 
         * @param externalLocation
         *        a consumer that will call methods on {@link ExternalLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalLocation(ExternalLocation)
         */
        default Builder externalLocation(Consumer<ExternalLocation.Builder> externalLocation) {
            return externalLocation(ExternalLocation.builder().applyMutation(externalLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String datasetName;

        private ExternalLocation externalLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetExportItem model) {
            datasetName(model.datasetName);
            externalLocation(model.externalLocation);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final ExternalLocation.Builder getExternalLocation() {
            return externalLocation != null ? externalLocation.toBuilder() : null;
        }

        public final void setExternalLocation(ExternalLocation.BuilderImpl externalLocation) {
            this.externalLocation = externalLocation != null ? externalLocation.build() : null;
        }

        @Override
        public final Builder externalLocation(ExternalLocation externalLocation) {
            this.externalLocation = externalLocation;
            return this;
        }

        @Override
        public DataSetExportItem build() {
            return new DataSetExportItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
