/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus;
import software.amazon.awssdk.services.m2.model.IdentifierListCopier;
import software.amazon.awssdk.services.m2.model.M2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBatchJobExecutionsRequest
extends M2Request
implements ToCopyableBuilder<Builder, ListBatchJobExecutionsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::applicationId)).setter(ListBatchJobExecutionsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<List<String>> EXECUTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionIds").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::executionIds)).setter(ListBatchJobExecutionsRequest.setter(Builder::executionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("executionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::jobName)).setter(ListBatchJobExecutionsRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("jobName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::maxResults)).setter(ListBatchJobExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::nextToken)).setter(ListBatchJobExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAfter").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::startedAfter)).setter(ListBatchJobExecutionsRequest.setter(Builder::startedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startedAfter").build()}).build();
    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedBefore").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::startedBefore)).setter(ListBatchJobExecutionsRequest.setter(Builder::startedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startedBefore").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListBatchJobExecutionsRequest.getter(ListBatchJobExecutionsRequest::statusAsString)).setter(ListBatchJobExecutionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, EXECUTION_IDS_FIELD, JOB_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STARTED_AFTER_FIELD, STARTED_BEFORE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBatchJobExecutionsRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final List<String> executionIds;
    private final String jobName;
    private final Integer maxResults;
    private final String nextToken;
    private final Instant startedAfter;
    private final Instant startedBefore;
    private final String status;

    private ListBatchJobExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.executionIds = builder.executionIds;
        this.jobName = builder.jobName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startedAfter = builder.startedAfter;
        this.startedBefore = builder.startedBefore;
        this.status = builder.status;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final boolean hasExecutionIds() {
        return this.executionIds != null && !(this.executionIds instanceof SdkAutoConstructList);
    }

    public final List<String> executionIds() {
        return this.executionIds;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant startedAfter() {
        return this.startedAfter;
    }

    public final Instant startedBefore() {
        return this.startedBefore;
    }

    public final BatchJobExecutionStatus status() {
        return BatchJobExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionIds() ? this.executionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobExecutionsRequest)) {
            return false;
        }
        ListBatchJobExecutionsRequest other = (ListBatchJobExecutionsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && this.hasExecutionIds() == other.hasExecutionIds() && Objects.equals(this.executionIds(), other.executionIds()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.startedAfter(), other.startedAfter()) && Objects.equals(this.startedBefore(), other.startedBefore()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListBatchJobExecutionsRequest").add("ApplicationId", (Object)this.applicationId()).add("ExecutionIds", this.hasExecutionIds() ? this.executionIds() : null).add("JobName", (Object)this.jobName()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("StartedAfter", (Object)this.startedAfter()).add("StartedBefore", (Object)this.startedBefore()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "executionIds": {
                return Optional.ofNullable(clazz.cast(this.executionIds()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "startedAfter": {
                return Optional.ofNullable(clazz.cast(this.startedAfter()));
            }
            case "startedBefore": {
                return Optional.ofNullable(clazz.cast(this.startedBefore()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("executionIds", EXECUTION_IDS_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("startedAfter", STARTED_AFTER_FIELD);
        map.put("startedBefore", STARTED_BEFORE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobExecutionsRequest, T> g) {
        return obj -> g.apply((ListBatchJobExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Request.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<String> executionIds = DefaultSdkAutoConstructList.getInstance();
        private String jobName;
        private Integer maxResults;
        private String nextToken;
        private Instant startedAfter;
        private Instant startedBefore;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobExecutionsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.executionIds(model.executionIds);
            this.jobName(model.jobName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.startedAfter(model.startedAfter);
            this.startedBefore(model.startedBefore);
            this.status(model.status);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Collection<String> getExecutionIds() {
            if (this.executionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionIds;
        }

        public final void setExecutionIds(Collection<String> executionIds) {
            this.executionIds = IdentifierListCopier.copy(executionIds);
        }

        @Override
        public final Builder executionIds(Collection<String> executionIds) {
            this.executionIds = IdentifierListCopier.copy(executionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionIds(String ... executionIds) {
            this.executionIds(Arrays.asList(executionIds));
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartedAfter() {
            return this.startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public final Instant getStartedBefore() {
            return this.startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BatchJobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBatchJobExecutionsRequest build() {
            return new ListBatchJobExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends M2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBatchJobExecutionsRequest> {
        public Builder applicationId(String var1);

        public Builder executionIds(Collection<String> var1);

        public Builder executionIds(String ... var1);

        public Builder jobName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder startedAfter(Instant var1);

        public Builder startedBefore(Instant var1);

        public Builder status(String var1);

        public Builder status(BatchJobExecutionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

