/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.DataSetExportTask;
import software.amazon.awssdk.services.m2.model.ListDataSetExportHistoryRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetExportHistoryResponse;

public class ListDataSetExportHistoryIterable
implements SdkIterable<ListDataSetExportHistoryResponse> {
    private final M2Client client;
    private final ListDataSetExportHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSetExportHistoryIterable(M2Client client, ListDataSetExportHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSetExportHistoryResponseFetcher();
    }

    public Iterator<ListDataSetExportHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSetExportTask> dataSetExportTasks() {
        Function<ListDataSetExportHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSetExportTasks() != null) {
                return response.dataSetExportTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSetExportHistoryResponseFetcher
    implements SyncPageFetcher<ListDataSetExportHistoryResponse> {
        private ListDataSetExportHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetExportHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSetExportHistoryResponse nextPage(ListDataSetExportHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetExportHistoryIterable.this.client.listDataSetExportHistory(ListDataSetExportHistoryIterable.this.firstRequest);
            }
            return ListDataSetExportHistoryIterable.this.client.listDataSetExportHistory((ListDataSetExportHistoryRequest)((Object)ListDataSetExportHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

