/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.JobIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BatchJobIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BatchJobIdentifier> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(S3BatchJobIdentifier.getter(S3BatchJobIdentifier::bucket)).setter(S3BatchJobIdentifier.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<JobIdentifier> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identifier").getter(S3BatchJobIdentifier.getter(S3BatchJobIdentifier::identifier)).setter(S3BatchJobIdentifier.setter(Builder::identifier)).constructor(JobIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPrefix").getter(S3BatchJobIdentifier.getter(S3BatchJobIdentifier::keyPrefix)).setter(S3BatchJobIdentifier.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, IDENTIFIER_FIELD, KEY_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3BatchJobIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final JobIdentifier identifier;
    private final String keyPrefix;

    private S3BatchJobIdentifier(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.identifier = builder.identifier;
        this.keyPrefix = builder.keyPrefix;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final JobIdentifier identifier() {
        return this.identifier;
    }

    public final String keyPrefix() {
        return this.keyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BatchJobIdentifier)) {
            return false;
        }
        S3BatchJobIdentifier other = (S3BatchJobIdentifier)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.keyPrefix(), other.keyPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"S3BatchJobIdentifier").add("Bucket", (Object)this.bucket()).add("Identifier", (Object)this.identifier()).add("KeyPrefix", (Object)this.keyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bucket", BUCKET_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("keyPrefix", KEY_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BatchJobIdentifier, T> g) {
        return obj -> g.apply((S3BatchJobIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private JobIdentifier identifier;
        private String keyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BatchJobIdentifier model) {
            this.bucket(model.bucket);
            this.identifier(model.identifier);
            this.keyPrefix(model.keyPrefix);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final JobIdentifier.Builder getIdentifier() {
            return this.identifier != null ? this.identifier.toBuilder() : null;
        }

        public final void setIdentifier(JobIdentifier.BuilderImpl identifier) {
            this.identifier = identifier != null ? identifier.build() : null;
        }

        @Override
        public final Builder identifier(JobIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public S3BatchJobIdentifier build() {
            return new S3BatchJobIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BatchJobIdentifier> {
        public Builder bucket(String var1);

        public Builder identifier(JobIdentifier var1);

        default public Builder identifier(Consumer<JobIdentifier.Builder> identifier) {
            return this.identifier((JobIdentifier)((JobIdentifier.Builder)JobIdentifier.builder().applyMutation(identifier)).build());
        }

        public Builder keyPrefix(String var1);
    }
}

