/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.DataSetImportItem;
import software.amazon.awssdk.services.m2.model.DataSetImportListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetImportConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetImportConfig> {
    private static final SdkField<List<DataSetImportItem>> DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSets").getter(DataSetImportConfig.getter(DataSetImportConfig::dataSets)).setter(DataSetImportConfig.setter(Builder::dataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetImportItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Location").getter(DataSetImportConfig.getter(DataSetImportConfig::s3Location)).setter(DataSetImportConfig.setter(Builder::s3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD, S3_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetImportConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DataSetImportItem> dataSets;
    private final String s3Location;
    private final Type type;

    private DataSetImportConfig(BuilderImpl builder) {
        this.dataSets = builder.dataSets;
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    public final boolean hasDataSets() {
        return this.dataSets != null && !(this.dataSets instanceof SdkAutoConstructList);
    }

    public final List<DataSetImportItem> dataSets() {
        return this.dataSets;
    }

    public final String s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSets() ? this.dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetImportConfig)) {
            return false;
        }
        DataSetImportConfig other = (DataSetImportConfig)obj;
        return this.hasDataSets() == other.hasDataSets() && Objects.equals(this.dataSets(), other.dataSets()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetImportConfig").add("DataSets", this.hasDataSets() ? this.dataSets() : null).add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSets": {
                return Optional.ofNullable(clazz.cast(this.dataSets()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public static DataSetImportConfig fromDataSets(List<DataSetImportItem> dataSets) {
        return (DataSetImportConfig)DataSetImportConfig.builder().dataSets(dataSets).build();
    }

    public static DataSetImportConfig fromS3Location(String s3Location) {
        return (DataSetImportConfig)DataSetImportConfig.builder().s3Location(s3Location).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSets", DATA_SETS_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetImportConfig, T> g) {
        return obj -> g.apply((DataSetImportConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATA_SETS,
        S3_LOCATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSetImportItem> dataSets = DefaultSdkAutoConstructList.getInstance();
        private String s3Location;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetImportConfig model) {
            this.dataSets(model.dataSets);
            this.s3Location(model.s3Location);
        }

        public final List<DataSetImportItem.Builder> getDataSets() {
            List<DataSetImportItem.Builder> result = DataSetImportListCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DataSetImportItem.BuilderImpl> dataSets) {
            List<DataSetImportItem> oldValue = this.dataSets;
            this.dataSets = DataSetImportListCopier.copyFromBuilder(dataSets);
            this.handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DataSetImportItem> dataSets) {
            List<DataSetImportItem> oldValue = this.dataSets;
            this.dataSets = DataSetImportListCopier.copy(dataSets);
            this.handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSetImportItem ... dataSets) {
            this.dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSetImportItem.Builder> ... dataSets) {
            this.dataSets(Stream.of(dataSets).map(c -> (DataSetImportItem)((DataSetImportItem.Builder)DataSetImportItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getS3Location() {
            return this.s3Location;
        }

        public final void setS3Location(String s3Location) {
            String oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
        }

        @Override
        public final Builder s3Location(String s3Location) {
            String oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
            return this;
        }

        public DataSetImportConfig build() {
            return new DataSetImportConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetImportConfig> {
        public Builder dataSets(Collection<DataSetImportItem> var1);

        public Builder dataSets(DataSetImportItem ... var1);

        public Builder dataSets(Consumer<DataSetImportItem.Builder> ... var1);

        public Builder s3Location(String var1);
    }
}

