/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.GdgAttributes;
import software.amazon.awssdk.services.m2.model.PoAttributes;
import software.amazon.awssdk.services.m2.model.PsAttributes;
import software.amazon.awssdk.services.m2.model.VsamAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetOrgAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetOrgAttributes> {
    private static final SdkField<GdgAttributes> GDG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gdg").getter(DatasetOrgAttributes.getter(DatasetOrgAttributes::gdg)).setter(DatasetOrgAttributes.setter(Builder::gdg)).constructor(GdgAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gdg").build()}).build();
    private static final SdkField<PoAttributes> PO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("po").getter(DatasetOrgAttributes.getter(DatasetOrgAttributes::po)).setter(DatasetOrgAttributes.setter(Builder::po)).constructor(PoAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("po").build()}).build();
    private static final SdkField<PsAttributes> PS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ps").getter(DatasetOrgAttributes.getter(DatasetOrgAttributes::ps)).setter(DatasetOrgAttributes.setter(Builder::ps)).constructor(PsAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ps").build()}).build();
    private static final SdkField<VsamAttributes> VSAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vsam").getter(DatasetOrgAttributes.getter(DatasetOrgAttributes::vsam)).setter(DatasetOrgAttributes.setter(Builder::vsam)).constructor(VsamAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vsam").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GDG_FIELD, PO_FIELD, PS_FIELD, VSAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetOrgAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GdgAttributes gdg;
    private final PoAttributes po;
    private final PsAttributes ps;
    private final VsamAttributes vsam;
    private final Type type;

    private DatasetOrgAttributes(BuilderImpl builder) {
        this.gdg = builder.gdg;
        this.po = builder.po;
        this.ps = builder.ps;
        this.vsam = builder.vsam;
        this.type = builder.type;
    }

    public final GdgAttributes gdg() {
        return this.gdg;
    }

    public final PoAttributes po() {
        return this.po;
    }

    public final PsAttributes ps() {
        return this.ps;
    }

    public final VsamAttributes vsam() {
        return this.vsam;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gdg());
        hashCode = 31 * hashCode + Objects.hashCode(this.po());
        hashCode = 31 * hashCode + Objects.hashCode(this.ps());
        hashCode = 31 * hashCode + Objects.hashCode(this.vsam());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetOrgAttributes)) {
            return false;
        }
        DatasetOrgAttributes other = (DatasetOrgAttributes)obj;
        return Objects.equals(this.gdg(), other.gdg()) && Objects.equals(this.po(), other.po()) && Objects.equals(this.ps(), other.ps()) && Objects.equals(this.vsam(), other.vsam());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetOrgAttributes").add("Gdg", (Object)this.gdg()).add("Po", (Object)this.po()).add("Ps", (Object)this.ps()).add("Vsam", (Object)this.vsam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gdg": {
                return Optional.ofNullable(clazz.cast(this.gdg()));
            }
            case "po": {
                return Optional.ofNullable(clazz.cast(this.po()));
            }
            case "ps": {
                return Optional.ofNullable(clazz.cast(this.ps()));
            }
            case "vsam": {
                return Optional.ofNullable(clazz.cast(this.vsam()));
            }
        }
        return Optional.empty();
    }

    public static DatasetOrgAttributes fromGdg(GdgAttributes gdg) {
        return (DatasetOrgAttributes)DatasetOrgAttributes.builder().gdg(gdg).build();
    }

    public static DatasetOrgAttributes fromGdg(Consumer<GdgAttributes.Builder> gdg) {
        GdgAttributes.Builder builder = GdgAttributes.builder();
        gdg.accept(builder);
        return DatasetOrgAttributes.fromGdg((GdgAttributes)builder.build());
    }

    public static DatasetOrgAttributes fromPo(PoAttributes po) {
        return (DatasetOrgAttributes)DatasetOrgAttributes.builder().po(po).build();
    }

    public static DatasetOrgAttributes fromPo(Consumer<PoAttributes.Builder> po) {
        PoAttributes.Builder builder = PoAttributes.builder();
        po.accept(builder);
        return DatasetOrgAttributes.fromPo((PoAttributes)builder.build());
    }

    public static DatasetOrgAttributes fromPs(PsAttributes ps) {
        return (DatasetOrgAttributes)DatasetOrgAttributes.builder().ps(ps).build();
    }

    public static DatasetOrgAttributes fromPs(Consumer<PsAttributes.Builder> ps) {
        PsAttributes.Builder builder = PsAttributes.builder();
        ps.accept(builder);
        return DatasetOrgAttributes.fromPs((PsAttributes)builder.build());
    }

    public static DatasetOrgAttributes fromVsam(VsamAttributes vsam) {
        return (DatasetOrgAttributes)DatasetOrgAttributes.builder().vsam(vsam).build();
    }

    public static DatasetOrgAttributes fromVsam(Consumer<VsamAttributes.Builder> vsam) {
        VsamAttributes.Builder builder = VsamAttributes.builder();
        vsam.accept(builder);
        return DatasetOrgAttributes.fromVsam((VsamAttributes)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gdg", GDG_FIELD);
        map.put("po", PO_FIELD);
        map.put("ps", PS_FIELD);
        map.put("vsam", VSAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetOrgAttributes, T> g) {
        return obj -> g.apply((DatasetOrgAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GDG,
        PO,
        PS,
        VSAM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GdgAttributes gdg;
        private PoAttributes po;
        private PsAttributes ps;
        private VsamAttributes vsam;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetOrgAttributes model) {
            this.gdg(model.gdg);
            this.po(model.po);
            this.ps(model.ps);
            this.vsam(model.vsam);
        }

        public final GdgAttributes.Builder getGdg() {
            return this.gdg != null ? this.gdg.toBuilder() : null;
        }

        public final void setGdg(GdgAttributes.BuilderImpl gdg) {
            GdgAttributes oldValue = this.gdg;
            this.gdg = gdg != null ? gdg.build() : null;
            this.handleUnionValueChange(Type.GDG, oldValue, this.gdg);
        }

        @Override
        public final Builder gdg(GdgAttributes gdg) {
            GdgAttributes oldValue = this.gdg;
            this.gdg = gdg;
            this.handleUnionValueChange(Type.GDG, oldValue, this.gdg);
            return this;
        }

        public final PoAttributes.Builder getPo() {
            return this.po != null ? this.po.toBuilder() : null;
        }

        public final void setPo(PoAttributes.BuilderImpl po) {
            PoAttributes oldValue = this.po;
            this.po = po != null ? po.build() : null;
            this.handleUnionValueChange(Type.PO, oldValue, this.po);
        }

        @Override
        public final Builder po(PoAttributes po) {
            PoAttributes oldValue = this.po;
            this.po = po;
            this.handleUnionValueChange(Type.PO, oldValue, this.po);
            return this;
        }

        public final PsAttributes.Builder getPs() {
            return this.ps != null ? this.ps.toBuilder() : null;
        }

        public final void setPs(PsAttributes.BuilderImpl ps) {
            PsAttributes oldValue = this.ps;
            this.ps = ps != null ? ps.build() : null;
            this.handleUnionValueChange(Type.PS, oldValue, this.ps);
        }

        @Override
        public final Builder ps(PsAttributes ps) {
            PsAttributes oldValue = this.ps;
            this.ps = ps;
            this.handleUnionValueChange(Type.PS, oldValue, this.ps);
            return this;
        }

        public final VsamAttributes.Builder getVsam() {
            return this.vsam != null ? this.vsam.toBuilder() : null;
        }

        public final void setVsam(VsamAttributes.BuilderImpl vsam) {
            VsamAttributes oldValue = this.vsam;
            this.vsam = vsam != null ? vsam.build() : null;
            this.handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
        }

        @Override
        public final Builder vsam(VsamAttributes vsam) {
            VsamAttributes oldValue = this.vsam;
            this.vsam = vsam;
            this.handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
            return this;
        }

        public DatasetOrgAttributes build() {
            return new DatasetOrgAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetOrgAttributes> {
        public Builder gdg(GdgAttributes var1);

        default public Builder gdg(Consumer<GdgAttributes.Builder> gdg) {
            return this.gdg((GdgAttributes)((GdgAttributes.Builder)GdgAttributes.builder().applyMutation(gdg)).build());
        }

        public Builder po(PoAttributes var1);

        default public Builder po(Consumer<PoAttributes.Builder> po) {
            return this.po((PoAttributes)((PoAttributes.Builder)PoAttributes.builder().applyMutation(po)).build());
        }

        public Builder ps(PsAttributes var1);

        default public Builder ps(Consumer<PsAttributes.Builder> ps) {
            return this.ps((PsAttributes)((PsAttributes.Builder)PsAttributes.builder().applyMutation(ps)).build());
        }

        public Builder vsam(VsamAttributes var1);

        default public Builder vsam(Consumer<VsamAttributes.Builder> vsam) {
            return this.vsam((VsamAttributes)((VsamAttributes.Builder)VsamAttributes.builder().applyMutation(vsam)).build());
        }
    }
}

