/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.ApplicationVersionLifecycle;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationVersionResponse
extends M2Response
implements ToCopyableBuilder<Builder, GetApplicationVersionResponse> {
    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("applicationVersion").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::applicationVersion)).setter(GetApplicationVersionResponse.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::creationTime)).setter(GetApplicationVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DEFINITION_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definitionContent").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::definitionContent)).setter(GetApplicationVersionResponse.setter(Builder::definitionContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionContent").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::description)).setter(GetApplicationVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::name)).setter(GetApplicationVersionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::statusAsString)).setter(GetApplicationVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetApplicationVersionResponse.getter(GetApplicationVersionResponse::statusReason)).setter(GetApplicationVersionResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_FIELD, CREATION_TIME_FIELD, DEFINITION_CONTENT_FIELD, DESCRIPTION_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApplicationVersionResponse.memberNameToFieldInitializer();
    private final Integer applicationVersion;
    private final Instant creationTime;
    private final String definitionContent;
    private final String description;
    private final String name;
    private final String status;
    private final String statusReason;

    private GetApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersion = builder.applicationVersion;
        this.creationTime = builder.creationTime;
        this.definitionContent = builder.definitionContent;
        this.description = builder.description;
        this.name = builder.name;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final Integer applicationVersion() {
        return this.applicationVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String definitionContent() {
        return this.definitionContent;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final ApplicationVersionLifecycle status() {
        return ApplicationVersionLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationVersionResponse)) {
            return false;
        }
        GetApplicationVersionResponse other = (GetApplicationVersionResponse)((Object)obj);
        return Objects.equals(this.applicationVersion(), other.applicationVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.definitionContent(), other.definitionContent()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationVersionResponse").add("ApplicationVersion", (Object)this.applicationVersion()).add("CreationTime", (Object)this.creationTime()).add("DefinitionContent", (Object)this.definitionContent()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "definitionContent": {
                return Optional.ofNullable(clazz.cast(this.definitionContent()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationVersion", APPLICATION_VERSION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("definitionContent", DEFINITION_CONTENT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationVersionResponse, T> g) {
        return obj -> g.apply((GetApplicationVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private Integer applicationVersion;
        private Instant creationTime;
        private String definitionContent;
        private String description;
        private String name;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationVersionResponse model) {
            super(model);
            this.applicationVersion(model.applicationVersion);
            this.creationTime(model.creationTime);
            this.definitionContent(model.definitionContent);
            this.description(model.description);
            this.name(model.name);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final Integer getApplicationVersion() {
            return this.applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDefinitionContent() {
            return this.definitionContent;
        }

        public final void setDefinitionContent(String definitionContent) {
            this.definitionContent = definitionContent;
        }

        @Override
        public final Builder definitionContent(String definitionContent) {
            this.definitionContent = definitionContent;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationVersionLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public GetApplicationVersionResponse build() {
            return new GetApplicationVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationVersionResponse> {
        public Builder applicationVersion(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder definitionContent(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationVersionLifecycle var1);

        public Builder statusReason(String var1);
    }
}

