/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.DataSetSummary;
import software.amazon.awssdk.services.m2.model.ListDataSetsRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetsResponse;

public class ListDataSetsIterable
implements SdkIterable<ListDataSetsResponse> {
    private final M2Client client;
    private final ListDataSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSetsIterable(M2Client client, ListDataSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSetsResponseFetcher();
    }

    public Iterator<ListDataSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSetSummary> dataSets() {
        Function<ListDataSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSets() != null) {
                return response.dataSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSetsResponseFetcher
    implements SyncPageFetcher<ListDataSetsResponse> {
        private ListDataSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSetsResponse nextPage(ListDataSetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetsIterable.this.client.listDataSets(ListDataSetsIterable.this.firstRequest);
            }
            return ListDataSetsIterable.this.client.listDataSets((ListDataSetsRequest)((Object)ListDataSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

