/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EfsStorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EfsStorageConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemId").getter(EfsStorageConfiguration.getter(EfsStorageConfiguration::fileSystemId)).setter(EfsStorageConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file-system-id").build()}).build();
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mountPoint").getter(EfsStorageConfiguration.getter(EfsStorageConfiguration::mountPoint)).setter(EfsStorageConfiguration.setter(Builder::mountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mount-point").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, MOUNT_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EfsStorageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String mountPoint;

    private EfsStorageConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.mountPoint = builder.mountPoint;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String mountPoint() {
        return this.mountPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EfsStorageConfiguration)) {
            return false;
        }
        EfsStorageConfiguration other = (EfsStorageConfiguration)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.mountPoint(), other.mountPoint());
    }

    public final String toString() {
        return ToString.builder((String)"EfsStorageConfiguration").add("FileSystemId", (Object)this.fileSystemId()).add("MountPoint", (Object)this.mountPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "mountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("file-system-id", FILE_SYSTEM_ID_FIELD);
        map.put("mount-point", MOUNT_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EfsStorageConfiguration, T> g) {
        return obj -> g.apply((EfsStorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String mountPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(EfsStorageConfiguration model) {
            this.fileSystemId(model.fileSystemId);
            this.mountPoint(model.mountPoint);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public EfsStorageConfiguration build() {
            return new EfsStorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EfsStorageConfiguration> {
        public Builder fileSystemId(String var1);

        public Builder mountPoint(String var1);
    }
}

