/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.AlternateKey;
import software.amazon.awssdk.services.m2.model.AlternateKeyListCopier;
import software.amazon.awssdk.services.m2.model.PrimaryKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VsamAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VsamAttributes> {
    private static final SdkField<List<AlternateKey>> ALTERNATE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alternateKeys").getter(VsamAttributes.getter(VsamAttributes::alternateKeys)).setter(VsamAttributes.setter(Builder::alternateKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlternateKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("compressed").getter(VsamAttributes.getter(VsamAttributes::compressed)).setter(VsamAttributes.setter(Builder::compressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressed").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encoding").getter(VsamAttributes.getter(VsamAttributes::encoding)).setter(VsamAttributes.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(VsamAttributes.getter(VsamAttributes::format)).setter(VsamAttributes.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<PrimaryKey> PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryKey").getter(VsamAttributes.getter(VsamAttributes::primaryKey)).setter(VsamAttributes.setter(Builder::primaryKey)).constructor(PrimaryKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_KEYS_FIELD, COMPRESSED_FIELD, ENCODING_FIELD, FORMAT_FIELD, PRIMARY_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("alternateKeys", ALTERNATE_KEYS_FIELD);
            this.put("compressed", COMPRESSED_FIELD);
            this.put("encoding", ENCODING_FIELD);
            this.put("format", FORMAT_FIELD);
            this.put("primaryKey", PRIMARY_KEY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AlternateKey> alternateKeys;
    private final Boolean compressed;
    private final String encoding;
    private final String format;
    private final PrimaryKey primaryKey;

    private VsamAttributes(BuilderImpl builder) {
        this.alternateKeys = builder.alternateKeys;
        this.compressed = builder.compressed;
        this.encoding = builder.encoding;
        this.format = builder.format;
        this.primaryKey = builder.primaryKey;
    }

    public final boolean hasAlternateKeys() {
        return this.alternateKeys != null && !(this.alternateKeys instanceof SdkAutoConstructList);
    }

    public final List<AlternateKey> alternateKeys() {
        return this.alternateKeys;
    }

    public final Boolean compressed() {
        return this.compressed;
    }

    public final String encoding() {
        return this.encoding;
    }

    public final String format() {
        return this.format;
    }

    public final PrimaryKey primaryKey() {
        return this.primaryKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternateKeys() ? this.alternateKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VsamAttributes)) {
            return false;
        }
        VsamAttributes other = (VsamAttributes)obj;
        return this.hasAlternateKeys() == other.hasAlternateKeys() && Objects.equals(this.alternateKeys(), other.alternateKeys()) && Objects.equals(this.compressed(), other.compressed()) && Objects.equals(this.encoding(), other.encoding()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.primaryKey(), other.primaryKey());
    }

    public final String toString() {
        return ToString.builder((String)"VsamAttributes").add("AlternateKeys", this.hasAlternateKeys() ? this.alternateKeys() : null).add("Compressed", (Object)this.compressed()).add("Encoding", (Object)this.encoding()).add("Format", (Object)this.format()).add("PrimaryKey", (Object)this.primaryKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alternateKeys": {
                return Optional.ofNullable(clazz.cast(this.alternateKeys()));
            }
            case "compressed": {
                return Optional.ofNullable(clazz.cast(this.compressed()));
            }
            case "encoding": {
                return Optional.ofNullable(clazz.cast(this.encoding()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "primaryKey": {
                return Optional.ofNullable(clazz.cast(this.primaryKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VsamAttributes, T> g) {
        return obj -> g.apply((VsamAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AlternateKey> alternateKeys = DefaultSdkAutoConstructList.getInstance();
        private Boolean compressed;
        private String encoding;
        private String format;
        private PrimaryKey primaryKey;

        private BuilderImpl() {
        }

        private BuilderImpl(VsamAttributes model) {
            this.alternateKeys(model.alternateKeys);
            this.compressed(model.compressed);
            this.encoding(model.encoding);
            this.format(model.format);
            this.primaryKey(model.primaryKey);
        }

        public final List<AlternateKey.Builder> getAlternateKeys() {
            List<AlternateKey.Builder> result = AlternateKeyListCopier.copyToBuilder(this.alternateKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateKeys(Collection<AlternateKey.BuilderImpl> alternateKeys) {
            this.alternateKeys = AlternateKeyListCopier.copyFromBuilder(alternateKeys);
        }

        @Override
        public final Builder alternateKeys(Collection<AlternateKey> alternateKeys) {
            this.alternateKeys = AlternateKeyListCopier.copy(alternateKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateKeys(AlternateKey ... alternateKeys) {
            this.alternateKeys(Arrays.asList(alternateKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateKeys(Consumer<AlternateKey.Builder> ... alternateKeys) {
            this.alternateKeys(Stream.of(alternateKeys).map(c -> (AlternateKey)((AlternateKey.Builder)AlternateKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCompressed() {
            return this.compressed;
        }

        public final void setCompressed(Boolean compressed) {
            this.compressed = compressed;
        }

        @Override
        public final Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final PrimaryKey.Builder getPrimaryKey() {
            return this.primaryKey != null ? this.primaryKey.toBuilder() : null;
        }

        public final void setPrimaryKey(PrimaryKey.BuilderImpl primaryKey) {
            this.primaryKey = primaryKey != null ? primaryKey.build() : null;
        }

        @Override
        public final Builder primaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public VsamAttributes build() {
            return new VsamAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VsamAttributes> {
        public Builder alternateKeys(Collection<AlternateKey> var1);

        public Builder alternateKeys(AlternateKey ... var1);

        public Builder alternateKeys(Consumer<AlternateKey.Builder> ... var1);

        public Builder compressed(Boolean var1);

        public Builder encoding(String var1);

        public Builder format(String var1);

        public Builder primaryKey(PrimaryKey var1);

        default public Builder primaryKey(Consumer<PrimaryKey.Builder> primaryKey) {
            return this.primaryKey((PrimaryKey)((PrimaryKey.Builder)PrimaryKey.builder().applyMutation(primaryKey)).build());
        }
    }
}

