/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.BatchJobIdentifier;
import software.amazon.awssdk.services.m2.model.BatchJobParametersMapCopier;
import software.amazon.awssdk.services.m2.model.M2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBatchJobRequest
extends M2Request
implements ToCopyableBuilder<Builder, StartBatchJobRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(StartBatchJobRequest.getter(StartBatchJobRequest::applicationId)).setter(StartBatchJobRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> AUTH_SECRETS_MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authSecretsManagerArn").getter(StartBatchJobRequest.getter(StartBatchJobRequest::authSecretsManagerArn)).setter(StartBatchJobRequest.setter(Builder::authSecretsManagerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authSecretsManagerArn").build()}).build();
    private static final SdkField<BatchJobIdentifier> BATCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchJobIdentifier").getter(StartBatchJobRequest.getter(StartBatchJobRequest::batchJobIdentifier)).setter(StartBatchJobRequest.setter(Builder::batchJobIdentifier)).constructor(BatchJobIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> JOB_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("jobParams").getter(StartBatchJobRequest.getter(StartBatchJobRequest::jobParams)).setter(StartBatchJobRequest.setter(Builder::jobParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, AUTH_SECRETS_MANAGER_ARN_FIELD, BATCH_JOB_IDENTIFIER_FIELD, JOB_PARAMS_FIELD));
    private final String applicationId;
    private final String authSecretsManagerArn;
    private final BatchJobIdentifier batchJobIdentifier;
    private final Map<String, String> jobParams;

    private StartBatchJobRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.authSecretsManagerArn = builder.authSecretsManagerArn;
        this.batchJobIdentifier = builder.batchJobIdentifier;
        this.jobParams = builder.jobParams;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String authSecretsManagerArn() {
        return this.authSecretsManagerArn;
    }

    public final BatchJobIdentifier batchJobIdentifier() {
        return this.batchJobIdentifier;
    }

    public final boolean hasJobParams() {
        return this.jobParams != null && !(this.jobParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> jobParams() {
        return this.jobParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authSecretsManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobParams() ? this.jobParams() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBatchJobRequest)) {
            return false;
        }
        StartBatchJobRequest other = (StartBatchJobRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.authSecretsManagerArn(), other.authSecretsManagerArn()) && Objects.equals(this.batchJobIdentifier(), other.batchJobIdentifier()) && this.hasJobParams() == other.hasJobParams() && Objects.equals(this.jobParams(), other.jobParams());
    }

    public final String toString() {
        return ToString.builder((String)"StartBatchJobRequest").add("ApplicationId", (Object)this.applicationId()).add("AuthSecretsManagerArn", (Object)this.authSecretsManagerArn()).add("BatchJobIdentifier", (Object)this.batchJobIdentifier()).add("JobParams", this.hasJobParams() ? this.jobParams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "authSecretsManagerArn": {
                return Optional.ofNullable(clazz.cast(this.authSecretsManagerArn()));
            }
            case "batchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.batchJobIdentifier()));
            }
            case "jobParams": {
                return Optional.ofNullable(clazz.cast(this.jobParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBatchJobRequest, T> g) {
        return obj -> g.apply((StartBatchJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Request.BuilderImpl
    implements Builder {
        private String applicationId;
        private String authSecretsManagerArn;
        private BatchJobIdentifier batchJobIdentifier;
        private Map<String, String> jobParams = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartBatchJobRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.authSecretsManagerArn(model.authSecretsManagerArn);
            this.batchJobIdentifier(model.batchJobIdentifier);
            this.jobParams(model.jobParams);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAuthSecretsManagerArn() {
            return this.authSecretsManagerArn;
        }

        public final void setAuthSecretsManagerArn(String authSecretsManagerArn) {
            this.authSecretsManagerArn = authSecretsManagerArn;
        }

        @Override
        public final Builder authSecretsManagerArn(String authSecretsManagerArn) {
            this.authSecretsManagerArn = authSecretsManagerArn;
            return this;
        }

        public final BatchJobIdentifier.Builder getBatchJobIdentifier() {
            return this.batchJobIdentifier != null ? this.batchJobIdentifier.toBuilder() : null;
        }

        public final void setBatchJobIdentifier(BatchJobIdentifier.BuilderImpl batchJobIdentifier) {
            this.batchJobIdentifier = batchJobIdentifier != null ? batchJobIdentifier.build() : null;
        }

        @Override
        public final Builder batchJobIdentifier(BatchJobIdentifier batchJobIdentifier) {
            this.batchJobIdentifier = batchJobIdentifier;
            return this;
        }

        public final Map<String, String> getJobParams() {
            if (this.jobParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.jobParams;
        }

        public final void setJobParams(Map<String, String> jobParams) {
            this.jobParams = BatchJobParametersMapCopier.copy(jobParams);
        }

        @Override
        public final Builder jobParams(Map<String, String> jobParams) {
            this.jobParams = BatchJobParametersMapCopier.copy(jobParams);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBatchJobRequest build() {
            return new StartBatchJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends M2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBatchJobRequest> {
        public Builder applicationId(String var1);

        public Builder authSecretsManagerArn(String var1);

        public Builder batchJobIdentifier(BatchJobIdentifier var1);

        default public Builder batchJobIdentifier(Consumer<BatchJobIdentifier.Builder> batchJobIdentifier) {
            return this.batchJobIdentifier((BatchJobIdentifier)((BatchJobIdentifier.Builder)BatchJobIdentifier.builder().applyMutation(batchJobIdentifier)).build());
        }

        public Builder jobParams(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

