/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.M2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelBatchJobExecutionRequest
extends M2Request
implements ToCopyableBuilder<Builder, CancelBatchJobExecutionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CancelBatchJobExecutionRequest.getter(CancelBatchJobExecutionRequest::applicationId)).setter(CancelBatchJobExecutionRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> AUTH_SECRETS_MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authSecretsManagerArn").getter(CancelBatchJobExecutionRequest.getter(CancelBatchJobExecutionRequest::authSecretsManagerArn)).setter(CancelBatchJobExecutionRequest.setter(Builder::authSecretsManagerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authSecretsManagerArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(CancelBatchJobExecutionRequest.getter(CancelBatchJobExecutionRequest::executionId)).setter(CancelBatchJobExecutionRequest.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("executionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, AUTH_SECRETS_MANAGER_ARN_FIELD, EXECUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("authSecretsManagerArn", AUTH_SECRETS_MANAGER_ARN_FIELD);
            this.put("executionId", EXECUTION_ID_FIELD);
        }
    });
    private final String applicationId;
    private final String authSecretsManagerArn;
    private final String executionId;

    private CancelBatchJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.authSecretsManagerArn = builder.authSecretsManagerArn;
        this.executionId = builder.executionId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String authSecretsManagerArn() {
        return this.authSecretsManagerArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authSecretsManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelBatchJobExecutionRequest)) {
            return false;
        }
        CancelBatchJobExecutionRequest other = (CancelBatchJobExecutionRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.authSecretsManagerArn(), other.authSecretsManagerArn()) && Objects.equals(this.executionId(), other.executionId());
    }

    public final String toString() {
        return ToString.builder((String)"CancelBatchJobExecutionRequest").add("ApplicationId", (Object)this.applicationId()).add("AuthSecretsManagerArn", (Object)this.authSecretsManagerArn()).add("ExecutionId", (Object)this.executionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "authSecretsManagerArn": {
                return Optional.ofNullable(clazz.cast(this.authSecretsManagerArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelBatchJobExecutionRequest, T> g) {
        return obj -> g.apply((CancelBatchJobExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Request.BuilderImpl
    implements Builder {
        private String applicationId;
        private String authSecretsManagerArn;
        private String executionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelBatchJobExecutionRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.authSecretsManagerArn(model.authSecretsManagerArn);
            this.executionId(model.executionId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAuthSecretsManagerArn() {
            return this.authSecretsManagerArn;
        }

        public final void setAuthSecretsManagerArn(String authSecretsManagerArn) {
            this.authSecretsManagerArn = authSecretsManagerArn;
        }

        @Override
        public final Builder authSecretsManagerArn(String authSecretsManagerArn) {
            this.authSecretsManagerArn = authSecretsManagerArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelBatchJobExecutionRequest build() {
            return new CancelBatchJobExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelBatchJobExecutionRequest> {
        public Builder applicationId(String var1);

        public Builder authSecretsManagerArn(String var1);

        public Builder executionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

