/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.m2.model.FileBatchJobIdentifier;
import software.amazon.awssdk.services.m2.model.S3BatchJobIdentifier;
import software.amazon.awssdk.services.m2.model.ScriptBatchJobIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchJobIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchJobIdentifier> {
    private static final SdkField<FileBatchJobIdentifier> FILE_BATCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileBatchJobIdentifier").getter(BatchJobIdentifier.getter(BatchJobIdentifier::fileBatchJobIdentifier)).setter(BatchJobIdentifier.setter(Builder::fileBatchJobIdentifier)).constructor(FileBatchJobIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileBatchJobIdentifier").build()}).build();
    private static final SdkField<S3BatchJobIdentifier> S3_BATCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3BatchJobIdentifier").getter(BatchJobIdentifier.getter(BatchJobIdentifier::s3BatchJobIdentifier)).setter(BatchJobIdentifier.setter(Builder::s3BatchJobIdentifier)).constructor(S3BatchJobIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BatchJobIdentifier").build()}).build();
    private static final SdkField<ScriptBatchJobIdentifier> SCRIPT_BATCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scriptBatchJobIdentifier").getter(BatchJobIdentifier.getter(BatchJobIdentifier::scriptBatchJobIdentifier)).setter(BatchJobIdentifier.setter(Builder::scriptBatchJobIdentifier)).constructor(ScriptBatchJobIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptBatchJobIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_BATCH_JOB_IDENTIFIER_FIELD, S3_BATCH_JOB_IDENTIFIER_FIELD, SCRIPT_BATCH_JOB_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final FileBatchJobIdentifier fileBatchJobIdentifier;
    private final S3BatchJobIdentifier s3BatchJobIdentifier;
    private final ScriptBatchJobIdentifier scriptBatchJobIdentifier;
    private final Type type;

    private BatchJobIdentifier(BuilderImpl builder) {
        this.fileBatchJobIdentifier = builder.fileBatchJobIdentifier;
        this.s3BatchJobIdentifier = builder.s3BatchJobIdentifier;
        this.scriptBatchJobIdentifier = builder.scriptBatchJobIdentifier;
        this.type = builder.type;
    }

    public final FileBatchJobIdentifier fileBatchJobIdentifier() {
        return this.fileBatchJobIdentifier;
    }

    public final S3BatchJobIdentifier s3BatchJobIdentifier() {
        return this.s3BatchJobIdentifier;
    }

    public final ScriptBatchJobIdentifier scriptBatchJobIdentifier() {
        return this.scriptBatchJobIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileBatchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BatchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptBatchJobIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchJobIdentifier)) {
            return false;
        }
        BatchJobIdentifier other = (BatchJobIdentifier)obj;
        return Objects.equals(this.fileBatchJobIdentifier(), other.fileBatchJobIdentifier()) && Objects.equals(this.s3BatchJobIdentifier(), other.s3BatchJobIdentifier()) && Objects.equals(this.scriptBatchJobIdentifier(), other.scriptBatchJobIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"BatchJobIdentifier").add("FileBatchJobIdentifier", (Object)this.fileBatchJobIdentifier()).add("S3BatchJobIdentifier", (Object)this.s3BatchJobIdentifier()).add("ScriptBatchJobIdentifier", (Object)this.scriptBatchJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileBatchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.fileBatchJobIdentifier()));
            }
            case "s3BatchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.s3BatchJobIdentifier()));
            }
            case "scriptBatchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scriptBatchJobIdentifier()));
            }
        }
        return Optional.empty();
    }

    public static BatchJobIdentifier fromFileBatchJobIdentifier(FileBatchJobIdentifier fileBatchJobIdentifier) {
        return (BatchJobIdentifier)BatchJobIdentifier.builder().fileBatchJobIdentifier(fileBatchJobIdentifier).build();
    }

    public static BatchJobIdentifier fromFileBatchJobIdentifier(Consumer<FileBatchJobIdentifier.Builder> fileBatchJobIdentifier) {
        FileBatchJobIdentifier.Builder builder = FileBatchJobIdentifier.builder();
        fileBatchJobIdentifier.accept(builder);
        return BatchJobIdentifier.fromFileBatchJobIdentifier((FileBatchJobIdentifier)builder.build());
    }

    public static BatchJobIdentifier fromS3BatchJobIdentifier(S3BatchJobIdentifier s3BatchJobIdentifier) {
        return (BatchJobIdentifier)BatchJobIdentifier.builder().s3BatchJobIdentifier(s3BatchJobIdentifier).build();
    }

    public static BatchJobIdentifier fromS3BatchJobIdentifier(Consumer<S3BatchJobIdentifier.Builder> s3BatchJobIdentifier) {
        S3BatchJobIdentifier.Builder builder = S3BatchJobIdentifier.builder();
        s3BatchJobIdentifier.accept(builder);
        return BatchJobIdentifier.fromS3BatchJobIdentifier((S3BatchJobIdentifier)builder.build());
    }

    public static BatchJobIdentifier fromScriptBatchJobIdentifier(ScriptBatchJobIdentifier scriptBatchJobIdentifier) {
        return (BatchJobIdentifier)BatchJobIdentifier.builder().scriptBatchJobIdentifier(scriptBatchJobIdentifier).build();
    }

    public static BatchJobIdentifier fromScriptBatchJobIdentifier(Consumer<ScriptBatchJobIdentifier.Builder> scriptBatchJobIdentifier) {
        ScriptBatchJobIdentifier.Builder builder = ScriptBatchJobIdentifier.builder();
        scriptBatchJobIdentifier.accept(builder);
        return BatchJobIdentifier.fromScriptBatchJobIdentifier((ScriptBatchJobIdentifier)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchJobIdentifier, T> g) {
        return obj -> g.apply((BatchJobIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE_BATCH_JOB_IDENTIFIER,
        S3_BATCH_JOB_IDENTIFIER,
        SCRIPT_BATCH_JOB_IDENTIFIER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FileBatchJobIdentifier fileBatchJobIdentifier;
        private S3BatchJobIdentifier s3BatchJobIdentifier;
        private ScriptBatchJobIdentifier scriptBatchJobIdentifier;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BatchJobIdentifier model) {
            this.fileBatchJobIdentifier(model.fileBatchJobIdentifier);
            this.s3BatchJobIdentifier(model.s3BatchJobIdentifier);
            this.scriptBatchJobIdentifier(model.scriptBatchJobIdentifier);
        }

        public final FileBatchJobIdentifier.Builder getFileBatchJobIdentifier() {
            return this.fileBatchJobIdentifier != null ? this.fileBatchJobIdentifier.toBuilder() : null;
        }

        public final void setFileBatchJobIdentifier(FileBatchJobIdentifier.BuilderImpl fileBatchJobIdentifier) {
            FileBatchJobIdentifier oldValue = this.fileBatchJobIdentifier;
            this.fileBatchJobIdentifier = fileBatchJobIdentifier != null ? fileBatchJobIdentifier.build() : null;
            this.handleUnionValueChange(Type.FILE_BATCH_JOB_IDENTIFIER, oldValue, this.fileBatchJobIdentifier);
        }

        @Override
        public final Builder fileBatchJobIdentifier(FileBatchJobIdentifier fileBatchJobIdentifier) {
            FileBatchJobIdentifier oldValue = this.fileBatchJobIdentifier;
            this.fileBatchJobIdentifier = fileBatchJobIdentifier;
            this.handleUnionValueChange(Type.FILE_BATCH_JOB_IDENTIFIER, oldValue, this.fileBatchJobIdentifier);
            return this;
        }

        public final S3BatchJobIdentifier.Builder getS3BatchJobIdentifier() {
            return this.s3BatchJobIdentifier != null ? this.s3BatchJobIdentifier.toBuilder() : null;
        }

        public final void setS3BatchJobIdentifier(S3BatchJobIdentifier.BuilderImpl s3BatchJobIdentifier) {
            S3BatchJobIdentifier oldValue = this.s3BatchJobIdentifier;
            this.s3BatchJobIdentifier = s3BatchJobIdentifier != null ? s3BatchJobIdentifier.build() : null;
            this.handleUnionValueChange(Type.S3_BATCH_JOB_IDENTIFIER, oldValue, this.s3BatchJobIdentifier);
        }

        @Override
        public final Builder s3BatchJobIdentifier(S3BatchJobIdentifier s3BatchJobIdentifier) {
            S3BatchJobIdentifier oldValue = this.s3BatchJobIdentifier;
            this.s3BatchJobIdentifier = s3BatchJobIdentifier;
            this.handleUnionValueChange(Type.S3_BATCH_JOB_IDENTIFIER, oldValue, this.s3BatchJobIdentifier);
            return this;
        }

        public final ScriptBatchJobIdentifier.Builder getScriptBatchJobIdentifier() {
            return this.scriptBatchJobIdentifier != null ? this.scriptBatchJobIdentifier.toBuilder() : null;
        }

        public final void setScriptBatchJobIdentifier(ScriptBatchJobIdentifier.BuilderImpl scriptBatchJobIdentifier) {
            ScriptBatchJobIdentifier oldValue = this.scriptBatchJobIdentifier;
            this.scriptBatchJobIdentifier = scriptBatchJobIdentifier != null ? scriptBatchJobIdentifier.build() : null;
            this.handleUnionValueChange(Type.SCRIPT_BATCH_JOB_IDENTIFIER, oldValue, this.scriptBatchJobIdentifier);
        }

        @Override
        public final Builder scriptBatchJobIdentifier(ScriptBatchJobIdentifier scriptBatchJobIdentifier) {
            ScriptBatchJobIdentifier oldValue = this.scriptBatchJobIdentifier;
            this.scriptBatchJobIdentifier = scriptBatchJobIdentifier;
            this.handleUnionValueChange(Type.SCRIPT_BATCH_JOB_IDENTIFIER, oldValue, this.scriptBatchJobIdentifier);
            return this;
        }

        public BatchJobIdentifier build() {
            return new BatchJobIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchJobIdentifier> {
        public Builder fileBatchJobIdentifier(FileBatchJobIdentifier var1);

        default public Builder fileBatchJobIdentifier(Consumer<FileBatchJobIdentifier.Builder> fileBatchJobIdentifier) {
            return this.fileBatchJobIdentifier((FileBatchJobIdentifier)((FileBatchJobIdentifier.Builder)FileBatchJobIdentifier.builder().applyMutation(fileBatchJobIdentifier)).build());
        }

        public Builder s3BatchJobIdentifier(S3BatchJobIdentifier var1);

        default public Builder s3BatchJobIdentifier(Consumer<S3BatchJobIdentifier.Builder> s3BatchJobIdentifier) {
            return this.s3BatchJobIdentifier((S3BatchJobIdentifier)((S3BatchJobIdentifier.Builder)S3BatchJobIdentifier.builder().applyMutation(s3BatchJobIdentifier)).build());
        }

        public Builder scriptBatchJobIdentifier(ScriptBatchJobIdentifier var1);

        default public Builder scriptBatchJobIdentifier(Consumer<ScriptBatchJobIdentifier.Builder> scriptBatchJobIdentifier) {
            return this.scriptBatchJobIdentifier((ScriptBatchJobIdentifier)((ScriptBatchJobIdentifier.Builder)ScriptBatchJobIdentifier.builder().applyMutation(scriptBatchJobIdentifier)).build());
        }
    }
}

