/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The supported properties for a PO type data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PoAttributes implements SdkPojo, Serializable, ToCopyableBuilder<PoAttributes.Builder, PoAttributes> {
    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encoding").getter(getter(PoAttributes::encoding)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(PoAttributes::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<List<String>> MEMBER_FILE_EXTENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("memberFileExtensions")
            .getter(getter(PoAttributes::memberFileExtensions))
            .setter(setter(Builder::memberFileExtensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberFileExtensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_FIELD, FORMAT_FIELD,
            MEMBER_FILE_EXTENSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encoding;

    private final String format;

    private final List<String> memberFileExtensions;

    private PoAttributes(BuilderImpl builder) {
        this.encoding = builder.encoding;
        this.format = builder.format;
        this.memberFileExtensions = builder.memberFileExtensions;
    }

    /**
     * <p>
     * The character set encoding of the data set.
     * </p>
     * 
     * @return The character set encoding of the data set.
     */
    public final String encoding() {
        return encoding;
    }

    /**
     * <p>
     * The format of the data set records.
     * </p>
     * 
     * @return The format of the data set records.
     */
    public final String format() {
        return format;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberFileExtensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberFileExtensions() {
        return memberFileExtensions != null && !(memberFileExtensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing one or more filename extensions, allowing you to specify which files to be included as PDS
     * member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberFileExtensions} method.
     * </p>
     * 
     * @return An array containing one or more filename extensions, allowing you to specify which files to be included
     *         as PDS member.
     */
    public final List<String> memberFileExtensions() {
        return memberFileExtensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encoding());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberFileExtensions() ? memberFileExtensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoAttributes)) {
            return false;
        }
        PoAttributes other = (PoAttributes) obj;
        return Objects.equals(encoding(), other.encoding()) && Objects.equals(format(), other.format())
                && hasMemberFileExtensions() == other.hasMemberFileExtensions()
                && Objects.equals(memberFileExtensions(), other.memberFileExtensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PoAttributes").add("Encoding", encoding()).add("Format", format())
                .add("MemberFileExtensions", hasMemberFileExtensions() ? memberFileExtensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encoding":
            return Optional.ofNullable(clazz.cast(encoding()));
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "memberFileExtensions":
            return Optional.ofNullable(clazz.cast(memberFileExtensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PoAttributes, T> g) {
        return obj -> g.apply((PoAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PoAttributes> {
        /**
         * <p>
         * The character set encoding of the data set.
         * </p>
         * 
         * @param encoding
         *        The character set encoding of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * The format of the data set records.
         * </p>
         * 
         * @param format
         *        The format of the data set records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * An array containing one or more filename extensions, allowing you to specify which files to be included as
         * PDS member.
         * </p>
         * 
         * @param memberFileExtensions
         *        An array containing one or more filename extensions, allowing you to specify which files to be
         *        included as PDS member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberFileExtensions(Collection<String> memberFileExtensions);

        /**
         * <p>
         * An array containing one or more filename extensions, allowing you to specify which files to be included as
         * PDS member.
         * </p>
         * 
         * @param memberFileExtensions
         *        An array containing one or more filename extensions, allowing you to specify which files to be
         *        included as PDS member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberFileExtensions(String... memberFileExtensions);
    }

    static final class BuilderImpl implements Builder {
        private String encoding;

        private String format;

        private List<String> memberFileExtensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PoAttributes model) {
            encoding(model.encoding);
            format(model.format);
            memberFileExtensions(model.memberFileExtensions);
        }

        public final String getEncoding() {
            return encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final Collection<String> getMemberFileExtensions() {
            if (memberFileExtensions instanceof SdkAutoConstructList) {
                return null;
            }
            return memberFileExtensions;
        }

        public final void setMemberFileExtensions(Collection<String> memberFileExtensions) {
            this.memberFileExtensions = String20ListCopier.copy(memberFileExtensions);
        }

        @Override
        public final Builder memberFileExtensions(Collection<String> memberFileExtensions) {
            this.memberFileExtensions = String20ListCopier.copy(memberFileExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberFileExtensions(String... memberFileExtensions) {
            memberFileExtensions(Arrays.asList(memberFileExtensions));
            return this;
        }

        @Override
        public PoAttributes build() {
            return new PoAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
