/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of information about the engine version for a specific application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineVersionsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EngineVersionsSummary.Builder, EngineVersionsSummary> {
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineType").getter(getter(EngineVersionsSummary::engineType)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(EngineVersionsSummary::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_TYPE_FIELD,
            ENGINE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engineType;

    private final String engineVersion;

    private EngineVersionsSummary(BuilderImpl builder) {
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
    }

    /**
     * <p>
     * The type of target platform for the application.
     * </p>
     * 
     * @return The type of target platform for the application.
     */
    public final String engineType() {
        return engineType;
    }

    /**
     * <p>
     * The version of the engine type used by the application.
     * </p>
     * 
     * @return The version of the engine type used by the application.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineType());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersionsSummary)) {
            return false;
        }
        EngineVersionsSummary other = (EngineVersionsSummary) obj;
        return Objects.equals(engineType(), other.engineType()) && Objects.equals(engineVersion(), other.engineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineVersionsSummary").add("EngineType", engineType()).add("EngineVersion", engineVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "engineType":
            return Optional.ofNullable(clazz.cast(engineType()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineVersionsSummary, T> g) {
        return obj -> g.apply((EngineVersionsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineVersionsSummary> {
        /**
         * <p>
         * The type of target platform for the application.
         * </p>
         * 
         * @param engineType
         *        The type of target platform for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The version of the engine type used by the application.
         * </p>
         * 
         * @param engineVersion
         *        The version of the engine type used by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);
    }

    static final class BuilderImpl implements Builder {
        private String engineType;

        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineVersionsSummary model) {
            engineType(model.engineType);
            engineVersion(model.engineVersion);
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        @Override
        public EngineVersionsSummary build() {
            return new EngineVersionsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
