/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.model.EngineVersionsSummary;
import software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse;

public class ListEngineVersionsPublisher
implements SdkPublisher<ListEngineVersionsResponse> {
    private final M2AsyncClient client;
    private final ListEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngineVersionsPublisher(M2AsyncClient client, ListEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngineVersionsPublisher(M2AsyncClient client, ListEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EngineVersionsSummary> engineVersions() {
        Function<ListEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineVersions() != null) {
                return response.engineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngineVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngineVersionsResponseFetcher
    implements AsyncPageFetcher<ListEngineVersionsResponse> {
        private ListEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngineVersionsResponse> nextPage(ListEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEngineVersionsPublisher.this.client.listEngineVersions(ListEngineVersionsPublisher.this.firstRequest);
            }
            return ListEngineVersionsPublisher.this.client.listEngineVersions((ListEngineVersionsRequest)((Object)ListEngineVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

