/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSetTaskLifecycle {
    CREATING("Creating"),
    RUNNING("Running"),
    COMPLETED("Completed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSetTaskLifecycle> VALUE_MAP;
    private final String value;

    private DataSetTaskLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSetTaskLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSetTaskLifecycle> knownValues() {
        EnumSet<DataSetTaskLifecycle> knownValues = EnumSet.allOf(DataSetTaskLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSetTaskLifecycle.class, DataSetTaskLifecycle::toString);
    }
}

