/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The supported properties for a PO type data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PoDetailAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<PoDetailAttributes.Builder, PoDetailAttributes> {
    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encoding").getter(getter(PoDetailAttributes::encoding)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(PoDetailAttributes::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_FIELD, FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encoding;

    private final String format;

    private PoDetailAttributes(BuilderImpl builder) {
        this.encoding = builder.encoding;
        this.format = builder.format;
    }

    /**
     * <p>
     * The character set encoding of the data set.
     * </p>
     * 
     * @return The character set encoding of the data set.
     */
    public final String encoding() {
        return encoding;
    }

    /**
     * <p>
     * The format of the data set records.
     * </p>
     * 
     * @return The format of the data set records.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encoding());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoDetailAttributes)) {
            return false;
        }
        PoDetailAttributes other = (PoDetailAttributes) obj;
        return Objects.equals(encoding(), other.encoding()) && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PoDetailAttributes").add("Encoding", encoding()).add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encoding":
            return Optional.ofNullable(clazz.cast(encoding()));
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PoDetailAttributes, T> g) {
        return obj -> g.apply((PoDetailAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PoDetailAttributes> {
        /**
         * <p>
         * The character set encoding of the data set.
         * </p>
         * 
         * @param encoding
         *        The character set encoding of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * The format of the data set records.
         * </p>
         * 
         * @param format
         *        The format of the data set records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl implements Builder {
        private String encoding;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(PoDetailAttributes model) {
            encoding(model.encoding);
            format(model.format);
        }

        public final String getEncoding() {
            return encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public PoDetailAttributes build() {
            return new PoDetailAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
