/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchJobExecutionsRequest extends M2Request implements
        ToCopyableBuilder<ListBatchJobExecutionsRequest.Builder, ListBatchJobExecutionsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ListBatchJobExecutionsRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<List<String>> EXECUTION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("executionIds")
            .getter(getter(ListBatchJobExecutionsRequest::executionIds))
            .setter(setter(Builder::executionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("executionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(ListBatchJobExecutionsRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("jobName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBatchJobExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBatchJobExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAfter").getter(getter(ListBatchJobExecutionsRequest::startedAfter))
            .setter(setter(Builder::startedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startedAfter").build()).build();

    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedBefore").getter(getter(ListBatchJobExecutionsRequest::startedBefore))
            .setter(setter(Builder::startedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startedBefore").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListBatchJobExecutionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            EXECUTION_IDS_FIELD, JOB_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STARTED_AFTER_FIELD, STARTED_BEFORE_FIELD,
            STATUS_FIELD));

    private final String applicationId;

    private final List<String> executionIds;

    private final String jobName;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startedAfter;

    private final Instant startedBefore;

    private final String status;

    private ListBatchJobExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.executionIds = builder.executionIds;
        this.jobName = builder.jobName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startedAfter = builder.startedAfter;
        this.startedBefore = builder.startedBefore;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionIds() {
        return executionIds != null && !(executionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifier of each batch job execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionIds} method.
     * </p>
     * 
     * @return The unique identifier of each batch job execution.
     */
    public final List<String> executionIds() {
        return executionIds;
    }

    /**
     * <p>
     * The name of each batch job execution.
     * </p>
     * 
     * @return The name of each batch job execution.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The maximum number of batch job executions to return.
     * </p>
     * 
     * @return The maximum number of batch job executions to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token to control the number of batch job executions displayed in the list.
     * </p>
     * 
     * @return A pagination token to control the number of batch job executions displayed in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The time after which the batch job executions started.
     * </p>
     * 
     * @return The time after which the batch job executions started.
     */
    public final Instant startedAfter() {
        return startedAfter;
    }

    /**
     * <p>
     * The time before the batch job executions started.
     * </p>
     * 
     * @return The time before the batch job executions started.
     */
    public final Instant startedBefore() {
        return startedBefore;
    }

    /**
     * <p>
     * The status of the batch job executions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BatchJobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch job executions.
     * @see BatchJobExecutionStatus
     */
    public final BatchJobExecutionStatus status() {
        return BatchJobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the batch job executions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BatchJobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch job executions.
     * @see BatchJobExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionIds() ? executionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobExecutionsRequest)) {
            return false;
        }
        ListBatchJobExecutionsRequest other = (ListBatchJobExecutionsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && hasExecutionIds() == other.hasExecutionIds()
                && Objects.equals(executionIds(), other.executionIds()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startedAfter(), other.startedAfter()) && Objects.equals(startedBefore(), other.startedBefore())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchJobExecutionsRequest").add("ApplicationId", applicationId())
                .add("ExecutionIds", hasExecutionIds() ? executionIds() : null).add("JobName", jobName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("StartedAfter", startedAfter())
                .add("StartedBefore", startedBefore()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "executionIds":
            return Optional.ofNullable(clazz.cast(executionIds()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startedAfter":
            return Optional.ofNullable(clazz.cast(startedAfter()));
        case "startedBefore":
            return Optional.ofNullable(clazz.cast(startedBefore()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobExecutionsRequest, T> g) {
        return obj -> g.apply((ListBatchJobExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListBatchJobExecutionsRequest> {
        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier of each batch job execution.
         * </p>
         * 
         * @param executionIds
         *        The unique identifier of each batch job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionIds(Collection<String> executionIds);

        /**
         * <p>
         * The unique identifier of each batch job execution.
         * </p>
         * 
         * @param executionIds
         *        The unique identifier of each batch job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionIds(String... executionIds);

        /**
         * <p>
         * The name of each batch job execution.
         * </p>
         * 
         * @param jobName
         *        The name of each batch job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The maximum number of batch job executions to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of batch job executions to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token to control the number of batch job executions displayed in the list.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to control the number of batch job executions displayed in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The time after which the batch job executions started.
         * </p>
         * 
         * @param startedAfter
         *        The time after which the batch job executions started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAfter(Instant startedAfter);

        /**
         * <p>
         * The time before the batch job executions started.
         * </p>
         * 
         * @param startedBefore
         *        The time before the batch job executions started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBefore(Instant startedBefore);

        /**
         * <p>
         * The status of the batch job executions.
         * </p>
         * 
         * @param status
         *        The status of the batch job executions.
         * @see BatchJobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchJobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the batch job executions.
         * </p>
         * 
         * @param status
         *        The status of the batch job executions.
         * @see BatchJobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchJobExecutionStatus
         */
        Builder status(BatchJobExecutionStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private List<String> executionIds = DefaultSdkAutoConstructList.getInstance();

        private String jobName;

        private Integer maxResults;

        private String nextToken;

        private Instant startedAfter;

        private Instant startedBefore;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobExecutionsRequest model) {
            super(model);
            applicationId(model.applicationId);
            executionIds(model.executionIds);
            jobName(model.jobName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startedAfter(model.startedAfter);
            startedBefore(model.startedBefore);
            status(model.status);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Collection<String> getExecutionIds() {
            if (executionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return executionIds;
        }

        public final void setExecutionIds(Collection<String> executionIds) {
            this.executionIds = IdentifierListCopier.copy(executionIds);
        }

        @Override
        public final Builder executionIds(Collection<String> executionIds) {
            this.executionIds = IdentifierListCopier.copy(executionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionIds(String... executionIds) {
            executionIds(Arrays.asList(executionIds));
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartedAfter() {
            return startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public final Instant getStartedBefore() {
            return startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BatchJobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBatchJobExecutionsRequest build() {
            return new ListBatchJobExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
