/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRouteCalculatorResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribeRouteCalculatorResponse> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::calculatorName)).setter(DescribeRouteCalculatorResponse.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()}).build();
    private static final SdkField<String> CALCULATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorArn").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::calculatorArn)).setter(DescribeRouteCalculatorResponse.setter(Builder::calculatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorArn").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::pricingPlanAsString)).setter(DescribeRouteCalculatorResponse.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::description)).setter(DescribeRouteCalculatorResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::createTime)).setter(DescribeRouteCalculatorResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::updateTime)).setter(DescribeRouteCalculatorResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::dataSource)).setter(DescribeRouteCalculatorResponse.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeRouteCalculatorResponse.getter(DescribeRouteCalculatorResponse::tags)).setter(DescribeRouteCalculatorResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD, CALCULATOR_ARN_FIELD, PRICING_PLAN_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, DATA_SOURCE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRouteCalculatorResponse.memberNameToFieldInitializer();
    private final String calculatorName;
    private final String calculatorArn;
    private final String pricingPlan;
    private final String description;
    private final Instant createTime;
    private final Instant updateTime;
    private final String dataSource;
    private final Map<String, String> tags;

    private DescribeRouteCalculatorResponse(BuilderImpl builder) {
        super(builder);
        this.calculatorName = builder.calculatorName;
        this.calculatorArn = builder.calculatorArn;
        this.pricingPlan = builder.pricingPlan;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.dataSource = builder.dataSource;
        this.tags = builder.tags;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final String calculatorArn() {
        return this.calculatorArn;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteCalculatorResponse)) {
            return false;
        }
        DescribeRouteCalculatorResponse other = (DescribeRouteCalculatorResponse)((Object)obj);
        return Objects.equals(this.calculatorName(), other.calculatorName()) && Objects.equals(this.calculatorArn(), other.calculatorArn()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.dataSource(), other.dataSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRouteCalculatorResponse").add("CalculatorName", (Object)this.calculatorName()).add("CalculatorArn", (Object)this.calculatorArn()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("DataSource", (Object)this.dataSource()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "CalculatorArn": {
                return Optional.ofNullable(clazz.cast(this.calculatorArn()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CalculatorName", CALCULATOR_NAME_FIELD);
        map.put("CalculatorArn", CALCULATOR_ARN_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteCalculatorResponse, T> g) {
        return obj -> g.apply((DescribeRouteCalculatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String calculatorName;
        private String calculatorArn;
        private String pricingPlan;
        private String description;
        private Instant createTime;
        private Instant updateTime;
        private String dataSource;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteCalculatorResponse model) {
            super(model);
            this.calculatorName(model.calculatorName);
            this.calculatorArn(model.calculatorArn);
            this.pricingPlan(model.pricingPlan);
            this.description(model.description);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.dataSource(model.dataSource);
            this.tags(model.tags);
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final String getCalculatorArn() {
            return this.calculatorArn;
        }

        public final void setCalculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
        }

        @Override
        public final Builder calculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeRouteCalculatorResponse build() {
            return new DescribeRouteCalculatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRouteCalculatorResponse> {
        public Builder calculatorName(String var1);

        public Builder calculatorArn(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

