/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.DataSourceConfiguration;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePlaceIndexResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribePlaceIndexResponse> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::indexName)).setter(DescribePlaceIndexResponse.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexArn").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::indexArn)).setter(DescribePlaceIndexResponse.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::pricingPlanAsString)).setter(DescribePlaceIndexResponse.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::description)).setter(DescribePlaceIndexResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::createTime)).setter(DescribePlaceIndexResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::updateTime)).setter(DescribePlaceIndexResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::dataSource)).setter(DescribePlaceIndexResponse.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceConfiguration").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::dataSourceConfiguration)).setter(DescribePlaceIndexResponse.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribePlaceIndexResponse.getter(DescribePlaceIndexResponse::tags)).setter(DescribePlaceIndexResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, INDEX_ARN_FIELD, PRICING_PLAN_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, DATA_SOURCE_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IndexName", INDEX_NAME_FIELD);
            this.put("IndexArn", INDEX_ARN_FIELD);
            this.put("PricingPlan", PRICING_PLAN_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("UpdateTime", UPDATE_TIME_FIELD);
            this.put("DataSource", DATA_SOURCE_FIELD);
            this.put("DataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String indexName;
    private final String indexArn;
    private final String pricingPlan;
    private final String description;
    private final Instant createTime;
    private final Instant updateTime;
    private final String dataSource;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final Map<String, String> tags;

    private DescribePlaceIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.pricingPlan = builder.pricingPlan;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.dataSource = builder.dataSource;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.tags = builder.tags;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlaceIndexResponse)) {
            return false;
        }
        DescribePlaceIndexResponse other = (DescribePlaceIndexResponse)((Object)obj);
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePlaceIndexResponse").add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("DataSource", (Object)this.dataSource()).add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "IndexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "DataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribePlaceIndexResponse, T> g) {
        return obj -> g.apply((DescribePlaceIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String indexName;
        private String indexArn;
        private String pricingPlan;
        private String description;
        private Instant createTime;
        private Instant updateTime;
        private String dataSource;
        private DataSourceConfiguration dataSourceConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlaceIndexResponse model) {
            super(model);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.pricingPlan(model.pricingPlan);
            this.description(model.description);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.dataSource(model.dataSource);
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.tags(model.tags);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribePlaceIndexResponse build() {
            return new DescribePlaceIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePlaceIndexResponse> {
        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

