/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrackersResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListTrackersResponseEntry> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(ListTrackersResponseEntry.getter(ListTrackersResponseEntry::trackerName)).setter(ListTrackersResponseEntry.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListTrackersResponseEntry.getter(ListTrackersResponseEntry::description)).setter(ListTrackersResponseEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(ListTrackersResponseEntry.getter(ListTrackersResponseEntry::pricingPlanAsString)).setter(ListTrackersResponseEntry.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(ListTrackersResponseEntry.getter(ListTrackersResponseEntry::pricingPlanDataSource)).setter(ListTrackersResponseEntry.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ListTrackersResponseEntry.getter(ListTrackersResponseEntry::createTime)).setter(ListTrackersResponseEntry.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ListTrackersResponseEntry.getter(ListTrackersResponseEntry::updateTime)).setter(ListTrackersResponseEntry.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trackerName;
    private final String description;
    private final String pricingPlan;
    private final String pricingPlanDataSource;
    private final Instant createTime;
    private final Instant updateTime;

    private ListTrackersResponseEntry(BuilderImpl builder) {
        this.trackerName = builder.trackerName;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final String description() {
        return this.description;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrackersResponseEntry)) {
            return false;
        }
        ListTrackersResponseEntry other = (ListTrackersResponseEntry)obj;
        return Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrackersResponseEntry").add("TrackerName", (Object)this.trackerName()).add("Description", (Object)this.description()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrackersResponseEntry, T> g) {
        return obj -> g.apply((ListTrackersResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trackerName;
        private String description;
        private String pricingPlan;
        private String pricingPlanDataSource;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrackersResponseEntry model) {
            this.trackerName(model.trackerName);
            this.description(model.description);
            this.pricingPlan(model.pricingPlan);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ListTrackersResponseEntry build() {
            return new ListTrackersResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListTrackersResponseEntry> {
        public Builder trackerName(String var1);

        public Builder description(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

