/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpeedUnit {
    KILOMETERS_PER_HOUR("KilometersPerHour"),
    MILES_PER_HOUR("MilesPerHour"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpeedUnit> VALUE_MAP;
    private final String value;

    private SpeedUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpeedUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpeedUnit> knownValues() {
        EnumSet<SpeedUnit> knownValues = EnumSet.allOf(SpeedUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpeedUnit.class, SpeedUnit::toString);
    }
}

