/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceError;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceErrorListCopier;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccess;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccessListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutGeofenceResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, BatchPutGeofenceResponse> {
    private static final SdkField<List<BatchPutGeofenceSuccess>> SUCCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successes").getter(BatchPutGeofenceResponse.getter(BatchPutGeofenceResponse::successes)).setter(BatchPutGeofenceResponse.setter(Builder::successes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutGeofenceSuccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchPutGeofenceError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchPutGeofenceResponse.getter(BatchPutGeofenceResponse::errors)).setter(BatchPutGeofenceResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutGeofenceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSES_FIELD, ERRORS_FIELD));
    private final List<BatchPutGeofenceSuccess> successes;
    private final List<BatchPutGeofenceError> errors;

    private BatchPutGeofenceResponse(BuilderImpl builder) {
        super(builder);
        this.successes = builder.successes;
        this.errors = builder.errors;
    }

    public final boolean hasSuccesses() {
        return this.successes != null && !(this.successes instanceof SdkAutoConstructList);
    }

    public final List<BatchPutGeofenceSuccess> successes() {
        return this.successes;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchPutGeofenceError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccesses() ? this.successes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutGeofenceResponse)) {
            return false;
        }
        BatchPutGeofenceResponse other = (BatchPutGeofenceResponse)((Object)obj);
        return this.hasSuccesses() == other.hasSuccesses() && Objects.equals(this.successes(), other.successes()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutGeofenceResponse").add("Successes", this.hasSuccesses() ? this.successes() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successes": {
                return Optional.ofNullable(clazz.cast(this.successes()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutGeofenceResponse, T> g) {
        return obj -> g.apply((BatchPutGeofenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<BatchPutGeofenceSuccess> successes = DefaultSdkAutoConstructList.getInstance();
        private List<BatchPutGeofenceError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutGeofenceResponse model) {
            super(model);
            this.successes(model.successes);
            this.errors(model.errors);
        }

        public final List<BatchPutGeofenceSuccess.Builder> getSuccesses() {
            List<BatchPutGeofenceSuccess.Builder> result = BatchPutGeofenceSuccessListCopier.copyToBuilder(this.successes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccesses(Collection<BatchPutGeofenceSuccess.BuilderImpl> successes) {
            this.successes = BatchPutGeofenceSuccessListCopier.copyFromBuilder(successes);
        }

        @Override
        public final Builder successes(Collection<BatchPutGeofenceSuccess> successes) {
            this.successes = BatchPutGeofenceSuccessListCopier.copy(successes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(BatchPutGeofenceSuccess ... successes) {
            this.successes(Arrays.asList(successes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(Consumer<BatchPutGeofenceSuccess.Builder> ... successes) {
            this.successes(Stream.of(successes).map(c -> (BatchPutGeofenceSuccess)((BatchPutGeofenceSuccess.Builder)BatchPutGeofenceSuccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchPutGeofenceError.Builder> getErrors() {
            List<BatchPutGeofenceError.Builder> result = BatchPutGeofenceErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchPutGeofenceError.BuilderImpl> errors) {
            this.errors = BatchPutGeofenceErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchPutGeofenceError> errors) {
            this.errors = BatchPutGeofenceErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchPutGeofenceError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchPutGeofenceError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchPutGeofenceError)((BatchPutGeofenceError.Builder)BatchPutGeofenceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutGeofenceResponse build() {
            return new BatchPutGeofenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutGeofenceResponse> {
        public Builder successes(Collection<BatchPutGeofenceSuccess> var1);

        public Builder successes(BatchPutGeofenceSuccess ... var1);

        public Builder successes(Consumer<BatchPutGeofenceSuccess.Builder> ... var1);

        public Builder errors(Collection<BatchPutGeofenceError> var1);

        public Builder errors(BatchPutGeofenceError ... var1);

        public Builder errors(Consumer<BatchPutGeofenceError.Builder> ... var1);
    }
}

