/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.DevicePosition;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse;

public class GetDevicePositionHistoryPublisher
implements SdkPublisher<GetDevicePositionHistoryResponse> {
    private final LocationAsyncClient client;
    private final GetDevicePositionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDevicePositionHistoryPublisher(LocationAsyncClient client, GetDevicePositionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDevicePositionHistoryPublisher(LocationAsyncClient client, GetDevicePositionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDevicePositionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDevicePositionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DevicePosition> devicePositions() {
        Function<GetDevicePositionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.devicePositions() != null) {
                return response.devicePositions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDevicePositionHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDevicePositionHistoryResponseFetcher
    implements AsyncPageFetcher<GetDevicePositionHistoryResponse> {
        private GetDevicePositionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetDevicePositionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDevicePositionHistoryResponse> nextPage(GetDevicePositionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetDevicePositionHistoryPublisher.this.client.getDevicePositionHistory(GetDevicePositionHistoryPublisher.this.firstRequest);
            }
            return GetDevicePositionHistoryPublisher.this.client.getDevicePositionHistory((GetDevicePositionHistoryRequest)((Object)GetDevicePositionHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

