/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PlaceCategoryListCopier;
import software.amazon.awssdk.services.location.model.PlaceSupplementalCategoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchForSuggestionsResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchForSuggestionsResult> {
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(SearchForSuggestionsResult.getter(SearchForSuggestionsResult::categories)).setter(SearchForSuggestionsResult.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(SearchForSuggestionsResult.getter(SearchForSuggestionsResult::placeId)).setter(SearchForSuggestionsResult.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()}).build();
    private static final SdkField<List<String>> SUPPLEMENTAL_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupplementalCategories").getter(SearchForSuggestionsResult.getter(SearchForSuggestionsResult::supplementalCategories)).setter(SearchForSuggestionsResult.setter(Builder::supplementalCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SearchForSuggestionsResult.getter(SearchForSuggestionsResult::text)).setter(SearchForSuggestionsResult.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD, PLACE_ID_FIELD, SUPPLEMENTAL_CATEGORIES_FIELD, TEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> categories;
    private final String placeId;
    private final List<String> supplementalCategories;
    private final String text;

    private SearchForSuggestionsResult(BuilderImpl builder) {
        this.categories = builder.categories;
        this.placeId = builder.placeId;
        this.supplementalCategories = builder.supplementalCategories;
        this.text = builder.text;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    public final String placeId() {
        return this.placeId;
    }

    public final boolean hasSupplementalCategories() {
        return this.supplementalCategories != null && !(this.supplementalCategories instanceof SdkAutoConstructList);
    }

    public final List<String> supplementalCategories() {
        return this.supplementalCategories;
    }

    public final String text() {
        return this.text;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupplementalCategories() ? this.supplementalCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchForSuggestionsResult)) {
            return false;
        }
        SearchForSuggestionsResult other = (SearchForSuggestionsResult)obj;
        return this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && Objects.equals(this.placeId(), other.placeId()) && this.hasSupplementalCategories() == other.hasSupplementalCategories() && Objects.equals(this.supplementalCategories(), other.supplementalCategories()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder((String)"SearchForSuggestionsResult").add("Categories", this.hasCategories() ? this.categories() : null).add("PlaceId", (Object)this.placeId()).add("SupplementalCategories", this.hasSupplementalCategories() ? this.supplementalCategories() : null).add("Text", (Object)this.text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
            case "SupplementalCategories": {
                return Optional.ofNullable(clazz.cast(this.supplementalCategories()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchForSuggestionsResult, T> g) {
        return obj -> g.apply((SearchForSuggestionsResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private String placeId;
        private List<String> supplementalCategories = DefaultSdkAutoConstructList.getInstance();
        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchForSuggestionsResult model) {
            this.categories(model.categories);
            this.placeId(model.placeId);
            this.supplementalCategories(model.supplementalCategories);
            this.text(model.text);
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = PlaceCategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = PlaceCategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final Collection<String> getSupplementalCategories() {
            if (this.supplementalCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supplementalCategories;
        }

        public final void setSupplementalCategories(Collection<String> supplementalCategories) {
            this.supplementalCategories = PlaceSupplementalCategoryListCopier.copy(supplementalCategories);
        }

        @Override
        public final Builder supplementalCategories(Collection<String> supplementalCategories) {
            this.supplementalCategories = PlaceSupplementalCategoryListCopier.copy(supplementalCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalCategories(String ... supplementalCategories) {
            this.supplementalCategories(Arrays.asList(supplementalCategories));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public SearchForSuggestionsResult build() {
            return new SearchForSuggestionsResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchForSuggestionsResult> {
        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder placeId(String var1);

        public Builder supplementalCategories(Collection<String> var1);

        public Builder supplementalCategories(String ... var1);

        public Builder text(String var1);
    }
}

