/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.DataSourceConfiguration;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePlaceIndexRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, UpdatePlaceIndexRequest> {
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceConfiguration").getter(UpdatePlaceIndexRequest.getter(UpdatePlaceIndexRequest::dataSourceConfiguration)).setter(UpdatePlaceIndexRequest.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePlaceIndexRequest.getter(UpdatePlaceIndexRequest::description)).setter(UpdatePlaceIndexRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(UpdatePlaceIndexRequest.getter(UpdatePlaceIndexRequest::indexName)).setter(UpdatePlaceIndexRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(UpdatePlaceIndexRequest.getter(UpdatePlaceIndexRequest::pricingPlanAsString)).setter(UpdatePlaceIndexRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, INDEX_NAME_FIELD, PRICING_PLAN_FIELD));
    private final DataSourceConfiguration dataSourceConfiguration;
    private final String description;
    private final String indexName;
    private final String pricingPlan;

    private UpdatePlaceIndexRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.description = builder.description;
        this.indexName = builder.indexName;
        this.pricingPlan = builder.pricingPlan;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String indexName() {
        return this.indexName;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlaceIndexRequest)) {
            return false;
        }
        UpdatePlaceIndexRequest other = (UpdatePlaceIndexRequest)((Object)obj);
        return Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePlaceIndexRequest").add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("Description", (Object)this.description()).add("IndexName", (Object)this.indexName()).add("PricingPlan", (Object)this.pricingPlanAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlaceIndexRequest, T> g) {
        return obj -> g.apply((UpdatePlaceIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private DataSourceConfiguration dataSourceConfiguration;
        private String description;
        private String indexName;
        private String pricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlaceIndexRequest model) {
            super(model);
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.description(model.description);
            this.indexName(model.indexName);
            this.pricingPlan(model.pricingPlan);
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlaceIndexRequest build() {
            return new UpdatePlaceIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePlaceIndexRequest> {
        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder indexName(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

