/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRouteCalculatorResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, UpdateRouteCalculatorResponse> {
    private static final SdkField<String> CALCULATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorArn").getter(UpdateRouteCalculatorResponse.getter(UpdateRouteCalculatorResponse::calculatorArn)).setter(UpdateRouteCalculatorResponse.setter(Builder::calculatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorArn").build()}).build();
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(UpdateRouteCalculatorResponse.getter(UpdateRouteCalculatorResponse::calculatorName)).setter(UpdateRouteCalculatorResponse.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(UpdateRouteCalculatorResponse.getter(UpdateRouteCalculatorResponse::updateTime)).setter(UpdateRouteCalculatorResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_ARN_FIELD, CALCULATOR_NAME_FIELD, UPDATE_TIME_FIELD));
    private final String calculatorArn;
    private final String calculatorName;
    private final Instant updateTime;

    private UpdateRouteCalculatorResponse(BuilderImpl builder) {
        super(builder);
        this.calculatorArn = builder.calculatorArn;
        this.calculatorName = builder.calculatorName;
        this.updateTime = builder.updateTime;
    }

    public final String calculatorArn() {
        return this.calculatorArn;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRouteCalculatorResponse)) {
            return false;
        }
        UpdateRouteCalculatorResponse other = (UpdateRouteCalculatorResponse)((Object)obj);
        return Objects.equals(this.calculatorArn(), other.calculatorArn()) && Objects.equals(this.calculatorName(), other.calculatorName()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRouteCalculatorResponse").add("CalculatorArn", (Object)this.calculatorArn()).add("CalculatorName", (Object)this.calculatorName()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorArn": {
                return Optional.ofNullable(clazz.cast(this.calculatorArn()));
            }
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRouteCalculatorResponse, T> g) {
        return obj -> g.apply((UpdateRouteCalculatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String calculatorArn;
        private String calculatorName;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRouteCalculatorResponse model) {
            super(model);
            this.calculatorArn(model.calculatorArn);
            this.calculatorName(model.calculatorName);
            this.updateTime(model.updateTime);
        }

        public final String getCalculatorArn() {
            return this.calculatorArn;
        }

        public final void setCalculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
        }

        @Override
        public final Builder calculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
            return this;
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateRouteCalculatorResponse build() {
            return new UpdateRouteCalculatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRouteCalculatorResponse> {
        public Builder calculatorArn(String var1);

        public Builder calculatorName(String var1);

        public Builder updateTime(Instant var1);
    }
}

