/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.model.ListGeofenceResponseEntry;
import software.amazon.awssdk.services.location.model.ListGeofencesRequest;
import software.amazon.awssdk.services.location.model.ListGeofencesResponse;

public class ListGeofencesPublisher
implements SdkPublisher<ListGeofencesResponse> {
    private final LocationAsyncClient client;
    private final ListGeofencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGeofencesPublisher(LocationAsyncClient client, ListGeofencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGeofencesPublisher(LocationAsyncClient client, ListGeofencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGeofencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGeofencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListGeofenceResponseEntry> entries() {
        Function<ListGeofencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGeofencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGeofencesResponseFetcher
    implements AsyncPageFetcher<ListGeofencesResponse> {
        private ListGeofencesResponseFetcher() {
        }

        public boolean hasNextPage(ListGeofencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGeofencesResponse> nextPage(ListGeofencesResponse previousPage) {
            if (previousPage == null) {
                return ListGeofencesPublisher.this.client.listGeofences(ListGeofencesPublisher.this.firstRequest);
            }
            return ListGeofencesPublisher.this.client.listGeofences((ListGeofencesRequest)((Object)ListGeofencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

